/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.exceptions;

import com.atlassian.querylang.exceptions.QueryException;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Joiner;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.stream.Collectors;

public class InvalidFieldQueryException
extends QueryException {
    private static final String FORMATTED_MESSAGE = "No field exists with the name: '%s'";
    private final String field;

    public InvalidFieldQueryException(String msg, String field) {
        super(msg);
        this.field = field;
    }

    public String getField() {
        return this.field;
    }

    public static InvalidFieldQueryException fieldDoesNotExist(String field, Iterable<String> fields) {
        Iterable<String> altFields = InvalidFieldQueryException.findAlternativeFields(field, fields);
        String altString = "";
        if (Iterables.size(altFields) > 0) {
            altString = " Did you mean one of : " + Joiner.on((String)", ").join(altFields);
        }
        throw new InvalidFieldQueryException(String.format(FORMATTED_MESSAGE + altString, field), field);
    }

    public static InvalidFieldQueryException fieldDoesNotExist(String field) {
        throw new InvalidFieldQueryException(String.format(FORMATTED_MESSAGE, field), field);
    }

    @VisibleForTesting
    static Iterable<String> findAlternativeFields(final String field, Iterable<String> fields) {
        ArrayList sorted = Lists.newArrayList(fields);
        final HashMap countCache = new HashMap();
        sorted.sort(new Comparator<String>(){

            @Override
            public int compare(String first, String second) {
                int match = this.countPrefixMatches(second) - this.countPrefixMatches(first);
                if (match != 0) {
                    return match;
                }
                return first.length() - second.length();
            }

            private int countPrefixMatches(String toCount) {
                Integer count = (Integer)countCache.get(toCount);
                if (count != null) {
                    return count;
                }
                count = 0;
                for (int i = 0; i < field.length() && toCount.length() > i && toCount.charAt(i) == field.charAt(i); ++i) {
                    count = i + 1;
                }
                countCache.put(toCount, count);
                return count;
            }
        });
        return Iterables.limit((Iterable)sorted.stream().filter(key -> {
            Integer count = (Integer)countCache.get(key);
            return count != null && count > 0;
        }).collect(Collectors.toList()), (int)5);
    }
}

