/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.querylang.fields;

import com.google.common.base.Preconditions;
import org.joda.time.DateTime;

public final class DateTimePrecision {
    private final DateTime dateTime;
    private final Precision precision;

    public DateTime calcStartDateTimeInclusive() {
        switch (this.getPrecision()) {
            case DAY: {
                return this.getDateTime().withTimeAtStartOfDay();
            }
            case MINUTE: {
                return this.getDateTime().withSecondOfMinute(0);
            }
        }
        throw new IllegalArgumentException("Unrecognised precision value : " + (Object)((Object)this.getPrecision()));
    }

    public DateTime calcEndDateTimeExclusive() {
        switch (this.getPrecision()) {
            case DAY: {
                return this.getDateTime().withTimeAtStartOfDay().plusDays(1);
            }
            case MINUTE: {
                return this.getDateTime().withSecondOfMinute(0).plusMinutes(1);
            }
        }
        throw new IllegalArgumentException("Unrecognised precision value : " + (Object)((Object)this.getPrecision()));
    }

    public DateTimePrecision(DateTime dateTime, Precision precision) {
        this.dateTime = (DateTime)Preconditions.checkNotNull((Object)dateTime);
        this.precision = (Precision)((Object)Preconditions.checkNotNull((Object)((Object)precision)));
    }

    public DateTime getDateTime() {
        return this.dateTime;
    }

    public Precision getPrecision() {
        return this.precision;
    }

    public static enum Precision {
        DAY,
        MINUTE;

    }
}

