/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.micrometer.analytics.events;

import com.atlassian.util.profiling.micrometer.analytics.events.AbstractMeterEvent;
import io.micrometer.core.instrument.FunctionTimer;
import io.micrometer.core.instrument.Meter;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class FunctionTimerEvent
extends AbstractMeterEvent {
    private final double total;
    private final double count;
    private final double mean;

    public FunctionTimerEvent(@Nonnull FunctionTimer timer, @Nonnull TimeUnit unit) {
        super((Meter)timer);
        this.total = timer.totalTime(Objects.requireNonNull(unit));
        this.count = timer.count();
        this.mean = timer.mean(unit);
    }

    public double getTotal() {
        return this.total;
    }

    public double getCount() {
        return this.count;
    }

    public double getMean() {
        return this.mean;
    }

    @Override
    public String getType() {
        return "functionTimer";
    }

    @Override
    public String toString() {
        return new ToStringBuilder((Object)this).appendSuper(super.toString()).append("total", this.total).append("count", this.count).append("mean", this.mean).toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FunctionTimerEvent that = (FunctionTimerEvent)o;
        return new EqualsBuilder().appendSuper(super.equals(o)).append(this.total, that.total).append(this.count, that.count).append(this.mean, that.mean).isEquals();
    }

    @Override
    public int hashCode() {
        return new HashCodeBuilder(17, 37).appendSuper(super.hashCode()).append(this.total).append(this.count).append(this.mean).toHashCode();
    }
}

