/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.strategy;

import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricsConfiguration;
import com.atlassian.util.profiling.Ticker;
import java.time.Duration;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public interface MetricStrategy {
    default public void onRequestEnd() {
    }

    default public void setConfiguration(MetricsConfiguration configuration) {
    }

    @Nonnull
    public Ticker startTimer(String var1);

    @Nonnull
    default public Ticker startTimer(MetricKey metricKey) {
        return this.startTimer(metricKey.getMetricName());
    }

    @Nonnull
    default public Ticker startLongRunningTimer(String metricName) {
        return Ticker.NO_OP;
    }

    @Nonnull
    default public Ticker startLongRunningTimer(MetricKey metricKey) {
        return Ticker.NO_OP;
    }

    public void updateHistogram(String var1, long var2);

    default public void updateHistogram(MetricKey metricKey, long value) {
        this.updateHistogram(metricKey.getMetricName(), value);
    }

    public void updateTimer(String var1, long var2, TimeUnit var4);

    default public void updateTimer(MetricKey metricKey, Duration time) {
        this.updateTimer(metricKey.getMetricName(), time.toNanos(), TimeUnit.NANOSECONDS);
    }
}

