/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.plugin.util.PluginKeyStack;
import com.atlassian.util.profiling.CompositeTicker;
import com.atlassian.util.profiling.Histogram;
import com.atlassian.util.profiling.LongRunningMetricTimer;
import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.MetricsConfiguration;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Tickers;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import java.time.Duration;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ParametersAreNonnullByDefault
public class Metrics {
    private static final MetricsConfiguration CONFIGURATION = new MetricsConfiguration();

    private Metrics() {
        throw new UnsupportedOperationException("Metrics is an utility class and should not be instantiated");
    }

    @Nonnull
    public static MetricsConfiguration getConfiguration() {
        return CONFIGURATION;
    }

    @Nonnull
    public static Histogram histogram(String name) {
        return Metrics.metric(name).histogram();
    }

    @Nonnull
    public static Histogram histogram(String name, Collection<MetricTag> tags) {
        return Metrics.metric(name).tags(tags).histogram();
    }

    @Nonnull
    public static Histogram histogram(String name, MetricTag ... tags) {
        return Metrics.metric(name).tags(tags).histogram();
    }

    @Nonnull
    public static MetricTimer timer(String name) {
        return new DefaultMetricTimer(MetricKey.metricKey(name));
    }

    @Nonnull
    public static MetricTimer timer(String name, Collection<MetricTag> tags) {
        return new DefaultMetricTimer(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static MetricTimer timer(String name, MetricTag ... tags) {
        return Metrics.metric(name).tags(tags).timer();
    }

    @Nonnull
    public static LongRunningMetricTimer longRunningTimer(String name) {
        return Metrics.longRunningTimer(name, Collections.emptySet());
    }

    @Nonnull
    public static LongRunningMetricTimer longRunningTimer(String name, Collection<MetricTag> tags) {
        return new DefaultLongRunningMetricTimer(MetricKey.metricKey(name, tags));
    }

    @Nonnull
    public static LongRunningMetricTimer longRunningTimer(String name, MetricTag ... tags) {
        return Metrics.longRunningTimer(name, Arrays.asList(tags));
    }

    @Nonnull
    public static Ticker startTimer(String name) {
        return Metrics.startTimer(name, Collections.emptySet());
    }

    @Nonnull
    public static Ticker startTimer(String name, MetricTag ... tags) {
        return Metrics.startTimer(name, Arrays.asList(tags));
    }

    @Nonnull
    public static Ticker startTimer(String name, Collection<MetricTag> tags) {
        return Metrics.metric(name).tags(tags).startTimer();
    }

    public static Builder metric(String name) {
        return new Builder(name);
    }

    @Nonnull
    public static Ticker startLongRunningTimer(String name) {
        return Metrics.startLongRunningTimer(name, Collections.emptySet());
    }

    @Nonnull
    public static Ticker startLongRunningTimer(String name, MetricTag ... tags) {
        return Metrics.startLongRunningTimer(name, Arrays.asList(tags));
    }

    @Nonnull
    public static Ticker startLongRunningTimer(String name, Collection<MetricTag> tags) {
        if (CONFIGURATION.isEnabled()) {
            return Metrics.longRunningTimer(name, tags).start();
        }
        return Ticker.NO_OP;
    }

    private static class DefaultHistogram
    implements Histogram {
        private static final Logger log = LoggerFactory.getLogger(DefaultHistogram.class);
        private final MetricKey metricKey;

        private DefaultHistogram(MetricKey metricKey) {
            this.metricKey = Objects.requireNonNull(metricKey, "metricKey");
        }

        @Override
        public void update(long value) {
            if (Metrics.getConfiguration().isEnabled()) {
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateHistogram(this.metricKey, value);
                    }
                    catch (RuntimeException e) {
                        log.warn("Failed to update histogram for {}", (Object)this.metricKey, (Object)e);
                    }
                }
            }
        }
    }

    @ParametersAreNonnullByDefault
    private static class DefaultLongRunningMetricTimer
    implements LongRunningMetricTimer {
        private static final Logger log = LoggerFactory.getLogger(DefaultLongRunningMetricTimer.class);
        private final MetricKey metricKey;

        DefaultLongRunningMetricTimer(MetricKey name) {
            this.metricKey = Objects.requireNonNull(name, "metricKey");
        }

        @Override
        @Nonnull
        public Ticker start() {
            Collection<MetricStrategy> metricStrategies = StrategiesRegistry.getMetricStrategies();
            if (!Metrics.getConfiguration().isEnabled() || metricStrategies.isEmpty()) {
                return Ticker.NO_OP;
            }
            CompositeTicker compositeTicker = null;
            for (MetricStrategy strategy : metricStrategies) {
                try {
                    compositeTicker = Tickers.addTicker(strategy.startLongRunningTimer(this.metricKey), compositeTicker);
                }
                catch (RuntimeException e) {
                    log.warn("Failed to start metric trace for {}", (Object)this.metricKey, (Object)e);
                }
            }
            return compositeTicker == null ? Ticker.NO_OP : compositeTicker;
        }
    }

    @ParametersAreNonnullByDefault
    private static class DefaultMetricTimer
    implements MetricTimer {
        private static final Logger log = LoggerFactory.getLogger(DefaultMetricTimer.class);
        private final MetricKey metricKey;

        DefaultMetricTimer(MetricKey name) {
            this.metricKey = Objects.requireNonNull(name, "metricKey");
        }

        @Override
        @Nonnull
        public Ticker start() {
            Collection<MetricStrategy> metricStrategies = StrategiesRegistry.getMetricStrategies();
            if (!Metrics.getConfiguration().isEnabled() || metricStrategies.isEmpty()) {
                return Ticker.NO_OP;
            }
            CompositeTicker compositeTicker = null;
            for (MetricStrategy strategy : metricStrategies) {
                try {
                    compositeTicker = Tickers.addTicker(strategy.startTimer(this.metricKey), compositeTicker);
                }
                catch (RuntimeException e) {
                    log.warn("Failed to start metric trace for {}", (Object)this.metricKey, (Object)e);
                }
            }
            return compositeTicker == null ? Ticker.NO_OP : compositeTicker;
        }

        @Override
        public void update(Duration time) {
            if (Metrics.getConfiguration().isEnabled()) {
                Objects.requireNonNull(time, "time");
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateTimer(this.metricKey, time);
                    }
                    catch (RuntimeException e) {
                        log.warn("Failed to update metric for {}", (Object)this.metricKey, (Object)e);
                    }
                }
            }
        }
    }

    public static class Builder {
        private final String name;
        private final Set<MetricTag> tags = new LinkedHashSet<MetricTag>();

        protected Builder(String name) {
            this.name = name;
        }

        public Builder tag(@Nonnull String key, @Nullable String value) {
            return this.tags(MetricTag.of(key, value));
        }

        public Builder tags(MetricTag ... tags) {
            return this.tags(Arrays.asList(tags));
        }

        public Builder tags(Iterable<MetricTag> tags) {
            for (MetricTag tag : tags) {
                this.tags.add(tag);
            }
            return this;
        }

        public Builder fromPluginKey(@Nullable String pluginKey) {
            this.tags.stream().filter(tag -> Objects.equals(tag.getKey(), "fromPluginKey")).findFirst().ifPresent(this.tags::remove);
            if (Objects.isNull(pluginKey)) {
                return this;
            }
            return this.tag("fromPluginKey", pluginKey);
        }

        public Builder invokerPluginKey(@Nullable String pluginKey) {
            this.tags.stream().filter(tag -> Objects.equals(tag.getKey(), "invokerPluginKey")).findFirst().ifPresent(this.tags::remove);
            if (Objects.isNull(pluginKey)) {
                return this;
            }
            return this.tag("invokerPluginKey", pluginKey);
        }

        public Builder withInvokerPluginKey() {
            return this.invokerPluginKey(PluginKeyStack.getFirstPluginKey());
        }

        public Builder withAnalytics() {
            return this.tags(MetricTag.SEND_ANALYTICS);
        }

        public Histogram histogram() {
            return new DefaultHistogram(MetricKey.metricKey(this.name, this.tags));
        }

        public MetricTimer timer() {
            return new DefaultMetricTimer(MetricKey.metricKey(this.name, this.tags));
        }

        public LongRunningMetricTimer longRunningTimer() {
            return new DefaultLongRunningMetricTimer(MetricKey.metricKey(this.name, this.tags));
        }

        public Ticker startTimer() {
            if (CONFIGURATION.isEnabled()) {
                return this.timer().start();
            }
            return Ticker.NO_OP;
        }

        public Ticker startLongRunningTimer() {
            if (CONFIGURATION.isEnabled()) {
                return this.longRunningTimer().start();
            }
            return Ticker.NO_OP;
        }
    }
}

