/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.MetricTag;
import com.atlassian.util.profiling.MetricTagContext;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;
import javax.annotation.concurrent.Immutable;

@ParametersAreNonnullByDefault
@Immutable
public final class MetricKey {
    private final String metricName;
    private final Collection<MetricTag> tags;

    private MetricKey(String metricName, Collection<MetricTag> tags) {
        this.metricName = Objects.requireNonNull(metricName);
        this.tags = tags;
    }

    @Nonnull
    public String getMetricName() {
        return this.metricName;
    }

    @Nonnull
    public Collection<MetricTag> getTags() {
        return this.tags;
    }

    public String toString() {
        return this.tags.isEmpty() ? this.metricName : this.metricName + this.getFormattedTags();
    }

    private String getFormattedTags() {
        return this.tags.stream().map(MetricTag::toString).collect(Collectors.joining(",", "[", "]"));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof MetricKey)) {
            return false;
        }
        MetricKey metricKey = (MetricKey)o;
        return this.metricName.equals(metricKey.metricName) && this.tags.equals(metricKey.tags);
    }

    public int hashCode() {
        return Objects.hash(this.metricName, this.tags);
    }

    public static MetricKey metricKey(String metricName) {
        return MetricKey.metricKey(metricName, Collections.emptyList());
    }

    public static MetricKey metricKey(String metricName, Collection<MetricTag> tags) {
        ArrayList<MetricTag> allTags = new ArrayList<MetricTag>(MetricTagContext.getAll());
        allTags.addAll(tags);
        return new MetricKey(metricName, allTags);
    }

    public static MetricKey metricKey(String metricName, MetricTag ... tags) {
        return MetricKey.metricKey(metricName, Arrays.asList(tags));
    }
}

