/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.CompositeTicker;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.Metrics;
import com.atlassian.util.profiling.ProfilerConfiguration;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Tickers;
import com.atlassian.util.profiling.Timer;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import com.atlassian.util.profiling.strategy.ProfilerStrategy;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Timers {
    private static final ProfilerConfiguration CONFIGURATION = new ProfilerConfiguration();
    private static final Logger log = LoggerFactory.getLogger(Timers.class);

    private Timers() {
        throw new UnsupportedOperationException("Timers is an utility class and should not be instantiated");
    }

    @Nonnull
    public static Timer concat(Timer ... timers) {
        return new CompositeTimer(timers);
    }

    @Nonnull
    public static ProfilerConfiguration getConfiguration() {
        return CONFIGURATION;
    }

    public static void onRequestEnd() {
        for (ProfilerStrategy profilerStrategy : StrategiesRegistry.getProfilerStrategies()) {
            try {
                profilerStrategy.onRequestEnd();
            }
            catch (Exception e) {
                log.warn("Error cleaning up profiler state for {}", (Object)profilerStrategy.getClass().getName(), (Object)e);
            }
        }
        for (MetricStrategy metricStrategy : StrategiesRegistry.getMetricStrategies()) {
            try {
                metricStrategy.onRequestEnd();
            }
            catch (Exception e) {
                log.warn("Error cleaning up metrics state for {}", (Object)metricStrategy.getClass().getName(), (Object)e);
            }
        }
    }

    @Nonnull
    public static Ticker start(@Nonnull String name) {
        if (CONFIGURATION.isEnabled()) {
            return Timers.timer(name).start(new String[0]);
        }
        return Ticker.NO_OP;
    }

    @Nonnull
    public static Ticker startWithMetric(@Nonnull String timerName) {
        if (CONFIGURATION.isEnabled()) {
            return Timers.timerWithMetric(timerName).start(new String[0]);
        }
        return Metrics.startTimer(timerName);
    }

    @Nonnull
    public static Ticker startWithMetric(@Nonnull String timerName, @Nonnull String metricName) {
        if (CONFIGURATION.isEnabled()) {
            return Timers.timerWithMetric(timerName, metricName).start(new String[0]);
        }
        return Metrics.startTimer(metricName);
    }

    @Nonnull
    public static Timer timer(@Nonnull String name) {
        return new DefaultTimer(Objects.requireNonNull(name, "name"));
    }

    @Nonnull
    public static Timer timerWithMetric(@Nonnull String traceName, @Nonnull String metricName) {
        final Timer timer = Timers.timer(traceName);
        final MetricTimer metricTimer = Metrics.timer(metricName);
        return new Timer(){

            @Override
            @Nonnull
            public Ticker start(Object ... callParameters) {
                Ticker traceTicker = timer.start(callParameters);
                Ticker metricTicker = metricTimer.start();
                return Tickers.of(traceTicker, metricTicker);
            }
        };
    }

    @Nonnull
    public static Timer timerWithMetric(@Nonnull String name) {
        return Timers.timerWithMetric(name, name);
    }

    private static class DefaultTimer
    implements Timer {
        private static final Logger log = LoggerFactory.getLogger(DefaultTimer.class);
        private final String name;

        DefaultTimer(String name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public Ticker start(Object ... callParameters) {
            String frameName;
            if (!CONFIGURATION.isEnabled()) {
                return Ticker.NO_OP;
            }
            if (callParameters == null || callParameters.length == 0) {
                frameName = this.name;
            } else {
                StringBuilder builder = new StringBuilder(this.name);
                boolean added = false;
                for (Object p : callParameters) {
                    String param;
                    String string = param = p == null ? null : String.valueOf(p);
                    if (param == null || param.isEmpty()) continue;
                    if (added) {
                        builder.append(", ");
                    } else {
                        builder.append("(");
                        added = true;
                    }
                    builder.append(param);
                }
                if (added) {
                    builder.append(")");
                }
                frameName = builder.toString();
            }
            CompositeTicker compositeTicker = null;
            for (ProfilerStrategy strategy : StrategiesRegistry.getProfilerStrategies()) {
                try {
                    compositeTicker = Tickers.addTicker(strategy.start(frameName), compositeTicker);
                }
                catch (Exception e) {
                    log.warn("Failed to start profiling frame for {}", (Object)frameName, (Object)e);
                }
            }
            return compositeTicker == null ? Ticker.NO_OP : compositeTicker;
        }
    }

    private static class CompositeTimer
    implements Timer {
        private final Timer[] timers;

        private CompositeTimer(@Nonnull Timer[] timers) {
            this.timers = Objects.requireNonNull(timers, "timers");
        }

        @Override
        @Nonnull
        public Ticker start(Object ... callParameters) {
            CompositeTicker ticker = null;
            for (Timer timer : this.timers) {
                if (timer == null) continue;
                ticker = Tickers.addTicker(timer.start(callParameters), ticker);
            }
            return ticker == null ? Ticker.NO_OP : ticker;
        }
    }
}

