/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.CompositeTicker;
import com.atlassian.util.profiling.Histogram;
import com.atlassian.util.profiling.MetricTimer;
import com.atlassian.util.profiling.MetricsConfiguration;
import com.atlassian.util.profiling.StrategiesRegistry;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.Tickers;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import java.util.Collection;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Metrics {
    private static final MetricsConfiguration CONFIGURATION = new MetricsConfiguration();

    private Metrics() {
        throw new UnsupportedOperationException("Metrics is an utility class and should not be instantiated");
    }

    @Nonnull
    public static MetricsConfiguration getConfiguration() {
        return CONFIGURATION;
    }

    @Nonnull
    public static Histogram histogram(@Nonnull String name) {
        return new DefaultHistogram(name);
    }

    @Nonnull
    public static MetricTimer timer(@Nonnull String name) {
        return new DefaultMetricTimer(Objects.requireNonNull(name, "name"));
    }

    @Nonnull
    public static Ticker startTimer(@Nonnull String name) {
        if (CONFIGURATION.isEnabled()) {
            return Metrics.timer(name).start();
        }
        return Ticker.NO_OP;
    }

    private static class DefaultHistogram
    implements Histogram {
        private static final Logger log = LoggerFactory.getLogger(DefaultHistogram.class);
        private final String name;

        private DefaultHistogram(String name) {
            this.name = name;
        }

        @Override
        public void update(long value) {
            if (Metrics.getConfiguration().isEnabled()) {
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateHistogram(this.name, value);
                    }
                    catch (Exception e) {
                        log.warn("Failed to update histogram for {}", (Object)this.name, (Object)e);
                    }
                }
            }
        }
    }

    private static class DefaultMetricTimer
    implements MetricTimer {
        private static final Logger log = LoggerFactory.getLogger(DefaultMetricTimer.class);
        private final String name;

        DefaultMetricTimer(String name) {
            this.name = name;
        }

        @Override
        @Nonnull
        public Ticker start() {
            Collection<MetricStrategy> metricStrategies = StrategiesRegistry.getMetricStrategies();
            if (!Metrics.getConfiguration().isEnabled() || metricStrategies.isEmpty()) {
                return Ticker.NO_OP;
            }
            CompositeTicker compositeTicker = null;
            for (MetricStrategy strategy : metricStrategies) {
                try {
                    compositeTicker = Tickers.addTicker(strategy.startTimer(this.name), compositeTicker);
                }
                catch (Exception e) {
                    log.warn("Failed to start metric trace for {}", (Object)this.name, (Object)e);
                }
            }
            return compositeTicker == null ? Ticker.NO_OP : compositeTicker;
        }

        @Override
        public void update(long time, @Nonnull TimeUnit timeUnit) {
            if (Metrics.getConfiguration().isEnabled()) {
                Objects.requireNonNull(timeUnit, "timeUnit");
                for (MetricStrategy strategy : StrategiesRegistry.getMetricStrategies()) {
                    try {
                        strategy.updateTimer(this.name, time, timeUnit);
                    }
                    catch (Exception e) {
                        log.warn("Failed to update metric for {}", (Object)this.name, (Object)e);
                    }
                }
            }
        }
    }
}

