package com.atlassian.util.profiling.strategy;

/**
 * Basic interface for profiling strategies, which are used in {@link com.atlassian.util.profiling.UtilTimerStack}.
 *
 * @since 2.0
 */
public interface ProfilingStrategy
{
    /**
     * This method is called on a start of the code snippet profiling
     * @param tag name
     */
    void start(String tag);

    /**
     * This method is called on a stop of the code snippet profiling
     * @param tag name
     */
    void stop(String tag);

    /**
     * Return <code>true</code> if this strategy is enabled, <code>false</code> otherwise.
     * @return <code>true</code> if this strategy is enabled, <code>false</code> otherwise.
     */
    boolean isEnabled();
}
