/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.object;

import com.atlassian.util.profiling.UtilTimerStack;
import com.atlassian.util.profiling.object.Profilable;
import com.atlassian.util.profiling.object.TimerInvocationHandler;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;

public class ObjectProfiler {
    public static Object getProfiledObject(Class interfaceClazz, Object o) {
        if (!UtilTimerStack.isActive()) {
            return o;
        }
        if (interfaceClazz.isInterface()) {
            TimerInvocationHandler timerHandler = new TimerInvocationHandler(o);
            return Proxy.newProxyInstance(interfaceClazz.getClassLoader(), new Class[]{interfaceClazz}, (InvocationHandler)timerHandler);
        }
        return o;
    }

    public static Object profiledInvoke(Method method, Object instance, Object[] args) throws Throwable {
        if (!UtilTimerStack.isActive()) {
            try {
                return method.invoke(instance, args);
            }
            catch (InvocationTargetException e) {
                if (e.getTargetException() != null) {
                    throw e.getTargetException();
                }
                throw e;
            }
        }
        String logLine = ObjectProfiler.getTrimmedClassName(method) + "." + method.getName() + "()";
        UtilTimerStack.push(logLine);
        try {
            Object returnValue = method.invoke(instance, args);
            if (returnValue != null && method.getReturnType().isInterface()) {
                Set interfaces = ObjectProfiler.getAllInterfaces(returnValue.getClass());
                TimerInvocationHandler timerHandler = new TimerInvocationHandler(returnValue);
                Object object = Proxy.newProxyInstance(returnValue.getClass().getClassLoader(), interfaces.toArray(new Class[interfaces.size()]), (InvocationHandler)timerHandler);
                return object;
            }
            Object object = returnValue;
            return object;
        }
        catch (InvocationTargetException e) {
            throw e.getTargetException();
        }
        finally {
            UtilTimerStack.pop(logLine);
        }
    }

    public static String getTrimmedClassName(Method method) {
        String classname = method.getDeclaringClass().getName();
        return classname.substring(classname.lastIndexOf(46) + 1);
    }

    public static Object profile(String caption, Profilable profilable) throws RuntimeException {
        Object o;
        try {
            UtilTimerStack.push(caption);
            o = profilable.profile();
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        finally {
            UtilTimerStack.pop(caption);
        }
        return o;
    }

    protected static Set getAllInterfaces(Class clazz) {
        HashSet interfaces = new HashSet();
        for (Class cls = clazz; cls != null; cls = cls.getSuperclass()) {
            interfaces.addAll(Arrays.asList(cls.getInterfaces()));
        }
        return interfaces;
    }
}

