/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling;

import com.atlassian.util.profiling.ProfilingTimerBean;
import com.atlassian.util.profiling.UtilTimerLogger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UtilTimerStack {
    public static final String ACTIVATE_PROPERTY = "atlassian.profile.activate";
    public static final String ACTIVATE_MEMORY_PROPERTY = "atlassian.profile.activate.memory";
    public static final String MIN_TIME = "atlassian.profile.mintime";
    public static final String MIN_TOTAL_TIME = "atlassian.profile.mintotaltime";
    public static final String MAX_FRAME_COUNT = "atlassian.profile.maxframecount";
    private static final Logger log = LoggerFactory.getLogger(UtilTimerStack.class);
    private static ThreadLocal<ProfilingTimerBean> current = new ThreadLocal();
    private static volatile int configuredMaxFrameCount;
    private static volatile long configuredMinTime;
    private static volatile long configuredMinTotalTime;
    private static volatile boolean activeFlag;
    private static volatile boolean profileMemoryFlag;
    private static UtilTimerLogger logger;

    public static void push(String name) {
        ProfilingTimerBean currentTimer;
        if (!UtilTimerStack.isActive()) {
            return;
        }
        ProfilingTimerBean newTimer = new ProfilingTimerBean(name);
        newTimer.setStartTime();
        if (UtilTimerStack.isProfileMemory()) {
            newTimer.setStartMem();
        }
        if ((currentTimer = current.get()) != null) {
            currentTimer.addChild(newTimer);
            newTimer.setFrameCount(currentTimer.getFrameCount() + 1);
        }
        current.set(newTimer);
    }

    public static void pop(String name) {
        ProfilingTimerBean currentTimer = current.get();
        if (currentTimer == null) {
            return;
        }
        currentTimer.setEndMem();
        if (name != null && name.equals(currentTimer.getResource())) {
            currentTimer.setEndTime();
            ProfilingTimerBean parent = currentTimer.getParent();
            if (parent == null) {
                if (currentTimer.getTotalTime() > UtilTimerStack.getMinTotalTime()) {
                    UtilTimerStack.printTimes(currentTimer);
                }
                current.remove();
            } else {
                if (currentTimer.getTotalTime() < UtilTimerStack.getMinTime() || currentTimer.getFrameCount() > UtilTimerStack.getMaxFrameCount()) {
                    parent.removeChild(currentTimer);
                }
                parent.setFrameCount(currentTimer.getFrameCount());
                current.set(parent);
            }
        } else {
            UtilTimerStack.printTimes(currentTimer);
            current.remove();
            log.debug("Unmatched Timer.  Was expecting {}, instead got {}", (Object)currentTimer.getResource(), (Object)name);
        }
    }

    private static void printTimes(ProfilingTimerBean currentTimer) {
        String printable = currentTimer.getPrintable(UtilTimerStack.getMinTime());
        if (printable != null && !"".equals(printable.trim())) {
            logger.log(printable);
        }
    }

    static UtilTimerLogger getLogger() {
        return logger;
    }

    public static void setLogger(UtilTimerLogger logger) {
        UtilTimerStack.logger = logger;
    }

    static int getMaxFrameCount() {
        return configuredMaxFrameCount;
    }

    public static void setMaxFrameCount(int maxFrameCount) {
        configuredMaxFrameCount = maxFrameCount;
    }

    static long getMinTime() {
        return configuredMinTime;
    }

    public static void setMinTime(long minTime) {
        configuredMinTime = minTime;
    }

    static long getMinTotalTime() {
        return configuredMinTotalTime;
    }

    public static void setMinTotalTime(long minTotalTime) {
        configuredMinTotalTime = minTotalTime;
    }

    public static boolean isActive() {
        return activeFlag;
    }

    public static void setActive(boolean active) {
        activeFlag = active;
    }

    public static boolean isProfileMemory() {
        return profileMemoryFlag;
    }

    public static void setProfileMemory(boolean active) {
        profileMemoryFlag = active;
    }

    static {
        activeFlag = false;
        profileMemoryFlag = false;
        configuredMaxFrameCount = Integer.getInteger(MAX_FRAME_COUNT, 1500);
        configuredMinTime = Long.getLong(MIN_TIME, 0L);
        configuredMinTotalTime = Long.getLong(MIN_TOTAL_TIME, 0L);
        activeFlag = "true".equalsIgnoreCase(System.getProperty(ACTIVATE_PROPERTY, "false"));
        profileMemoryFlag = "true".equalsIgnoreCase(System.getProperty(ACTIVATE_MEMORY_PROPERTY, "false"));
        logger = new UtilTimerLogger(){

            @Override
            public void log(String s) {
                log.debug(s);
            }
        };
    }
}

