/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.micrometer.util;

import com.atlassian.annotations.VisibleForTesting;
import io.micrometer.core.instrument.Meter;
import io.micrometer.core.instrument.Statistic;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.config.NamingConvention;
import io.micrometer.core.instrument.util.HierarchicalNameMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class QualifiedCompatibleHierarchicalNameMapper
implements HierarchicalNameMapper {
    @VisibleForTesting
    static final String CATEGORY_BASE_KEY = "category";
    @VisibleForTesting
    static final String NAME_KEY = "name";
    @VisibleForTesting
    static final String TAG_KEY_KEY = "tagKey";
    @VisibleForTesting
    static final String TAG_VALUE_KEY = "tagValue";
    @VisibleForTesting
    static final String TYPE_KEY = "type";
    @VisibleForTesting
    static final String METRICS_PROPERTY = "metrics";
    @VisibleForTesting
    static final String KEY_PROPERTY_PAIR_DELIMITER = ",";
    @VisibleForTesting
    static final String NAME_GROUPING_DELIMITER = ".";
    @VisibleForTesting
    static final String STATISTIC_TAG_KEY = "statistic";
    static final String CURRENT = "current";
    private static final String KEY_PROPERTY_SEPARATOR = "=";
    @VisibleForTesting
    static final int STARTING_COUNT = 0;

    @Nonnull
    public String toHierarchicalName(@Nonnull Meter.Id meterId, @Nonnull NamingConvention namingConvention) {
        Objects.requireNonNull(meterId, "meterId");
        Objects.requireNonNull(namingConvention, "namingConvention");
        ArrayList<Tag> tags = new ArrayList<Tag>(meterId.getConventionTags(namingConvention));
        StringBuilder metricName = new StringBuilder(meterId.getConventionName(NamingConvention.identity));
        Optional<Tag> statisticTag = QualifiedCompatibleHierarchicalNameMapper.findInsertedStatisticTag(tags);
        if (statisticTag.isPresent()) {
            tags.remove(statisticTag.get());
            metricName.append(NAME_GROUPING_DELIMITER).append(statisticTag.get().getValue());
        }
        String hierarchicalName = QualifiedCompatibleHierarchicalNameMapper.buildTagsString(tags) + QualifiedCompatibleHierarchicalNameMapper.buildCategoriesAndNameString(metricName.toString());
        String safeHierarchicalName = hierarchicalName.replaceAll(" ", "_");
        return safeHierarchicalName;
    }

    public static String buildSiblingLongRunningTimerMetricName(String metricName) {
        return metricName + NAME_GROUPING_DELIMITER + CURRENT;
    }

    private static Optional<Tag> findInsertedStatisticTag(List<Tag> tags) {
        return tags.stream().filter(tag -> STATISTIC_TAG_KEY.equals(tag.getKey()) && Arrays.stream((Statistic[])Statistic.class.getEnumConstants()).map(Statistic::getTagValueRepresentation).anyMatch(statisticTagValue -> Objects.equals(tag.getValue(), statisticTagValue))).findFirst();
    }

    private static String buildTagsString(List<Tag> tags) {
        StringBuilder tagStringBuilder = new StringBuilder();
        int tagCount = 0;
        for (Tag tag : tags) {
            tagStringBuilder.append(QualifiedCompatibleHierarchicalNameMapper.buildNumberedKeyProperty(TAG_KEY_KEY, tag.getKey(), tagCount)).append(QualifiedCompatibleHierarchicalNameMapper.buildNumberedKeyProperty(TAG_VALUE_KEY, tag.getValue(), tagCount));
            ++tagCount;
        }
        return tagStringBuilder.toString();
    }

    private static String buildCategoriesAndNameString(String metricName) {
        List jmxCategories = Arrays.stream(metricName.split("\\.")).collect(Collectors.toList());
        String jmxName = (String)jmxCategories.remove(jmxCategories.size() - 1);
        StringBuilder jmxStringBuilder = new StringBuilder();
        jmxStringBuilder.append(QualifiedCompatibleHierarchicalNameMapper.buildIntermediateKeyProperty(TYPE_KEY, METRICS_PROPERTY));
        int categoriesCount = 0;
        for (String category : jmxCategories) {
            jmxStringBuilder.append(QualifiedCompatibleHierarchicalNameMapper.buildNumberedKeyProperty(CATEGORY_BASE_KEY, category, categoriesCount));
            ++categoriesCount;
        }
        jmxStringBuilder.append(QualifiedCompatibleHierarchicalNameMapper.buildKeyProperty(NAME_KEY, jmxName));
        return jmxStringBuilder.toString();
    }

    private static String twoDigitMinimumLeftPad(int integerToPad) {
        return String.format("%02d", integerToPad);
    }

    @VisibleForTesting
    static String buildNumberedKeyProperty(String key, String value, int number) {
        return QualifiedCompatibleHierarchicalNameMapper.buildIntermediateKeyProperty(key + QualifiedCompatibleHierarchicalNameMapper.twoDigitMinimumLeftPad(number), value);
    }

    private static String buildIntermediateKeyProperty(String key, String value) {
        return QualifiedCompatibleHierarchicalNameMapper.buildKeyProperty(key, value) + KEY_PROPERTY_PAIR_DELIMITER;
    }

    @VisibleForTesting
    static String buildKeyProperty(String key, String value) {
        return key + KEY_PROPERTY_SEPARATOR + value;
    }
}

