/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.util.profiling.micrometer;

import com.atlassian.util.profiling.MetricKey;
import com.atlassian.util.profiling.Ticker;
import com.atlassian.util.profiling.micrometer.util.QualifiedCompatibleHierarchicalNameMapper;
import com.atlassian.util.profiling.strategy.MetricStrategy;
import io.micrometer.core.instrument.LongTaskTimer;
import io.micrometer.core.instrument.MeterRegistry;
import io.micrometer.core.instrument.Tag;
import io.micrometer.core.instrument.Timer;
import java.time.Duration;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.ParametersAreNonnullByDefault;

@ParametersAreNonnullByDefault
public class MicrometerStrategy
implements MetricStrategy {
    private final MeterRegistry registry;

    public MicrometerStrategy(MeterRegistry registry) {
        this.registry = Objects.requireNonNull(registry, "registry");
    }

    @Nonnull
    public Ticker startTimer(String metricName) {
        return this.startTimer(this.registry.timer(metricName, new String[0]));
    }

    @Nonnull
    public Ticker startTimer(MetricKey metricKey) {
        return this.startTimer(this.registry.timer(metricKey.getMetricName(), MicrometerStrategy.getTags(metricKey)));
    }

    @Nonnull
    public Ticker startLongRunningTimer(String metricName) {
        return this.startLongRunningTimer(metricName, null);
    }

    @Nonnull
    public Ticker startLongRunningTimer(@Nonnull MetricKey metricKey) {
        Objects.requireNonNull(metricKey, "metricKey");
        return this.startLongRunningTimer(metricKey.getMetricName(), MicrometerStrategy.getTags(metricKey));
    }

    private Ticker startTimer(Timer timer) {
        Timer.Sample sample = Timer.start((MeterRegistry)this.registry);
        return () -> sample.stop(timer);
    }

    private Ticker startLongRunningTimer(String metricName, Collection<Tag> metricTags) {
        LongTaskTimer.Sample longTimerSample = this.registry.more().longTaskTimer(QualifiedCompatibleHierarchicalNameMapper.buildSiblingLongRunningTimerMetricName(metricName), metricTags).start();
        Timer timer = this.registry.timer(metricName, metricTags);
        Timer.Sample timerSample = Timer.start((MeterRegistry)this.registry);
        return () -> {
            longTimerSample.stop();
            timerSample.stop(timer);
        };
    }

    public void updateHistogram(String metricName, long value) {
        this.registry.summary(metricName, new String[0]).record((double)value);
    }

    public void updateHistogram(MetricKey metricKey, long value) {
        this.registry.summary(metricKey.getMetricName(), MicrometerStrategy.getTags(metricKey)).record((double)value);
    }

    public void updateTimer(MetricKey metricKey, Duration time) {
        this.registry.timer(metricKey.getMetricName(), MicrometerStrategy.getTags(metricKey)).record(time);
    }

    public void updateTimer(String metricName, long time, TimeUnit timeUnit) {
        this.registry.timer(metricName, new String[0]).record(time, timeUnit);
    }

    private static List<Tag> getTags(MetricKey metricKey) {
        return metricKey.getTags().stream().map(tag -> Tag.of((String)tag.getKey(), (String)tag.getValue())).collect(Collectors.toList());
    }
}

