/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.api.route;

import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.prettyurls.api.route.DestinationUrlGenerator;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RoutePredicates;
import com.atlassian.prettyurls.api.route.UrlRouteRule;
import com.atlassian.prettyurls.api.route.UrlRouteRuleSetKey;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.Collections;
import java.util.List;

public class UrlRouteRuleSet {
    private final List<UrlRouteRule> urlRouteRules;
    private final List<String> topLevelPaths;
    private final UrlRouteRuleSetKey key;
    private final FilterLocation filterLocation;
    private final RoutePredicate<UrlRouteRuleSet> predicate;

    UrlRouteRuleSet(UrlRouteRuleSetKey key, List<String> topLevelPaths, List<UrlRouteRule> urlRouteRules, FilterLocation filterLocation, RoutePredicate<UrlRouteRuleSet> predicate) {
        this.key = (UrlRouteRuleSetKey)Preconditions.checkNotNull((Object)key);
        this.urlRouteRules = (List)Preconditions.checkNotNull(urlRouteRules);
        this.topLevelPaths = (List)Preconditions.checkNotNull(topLevelPaths);
        this.filterLocation = (FilterLocation)Preconditions.checkNotNull((Object)filterLocation);
        this.predicate = (RoutePredicate)Preconditions.checkNotNull(predicate);
    }

    public List<String> getTopLevelPaths() {
        return Lists.newArrayList(this.topLevelPaths);
    }

    public List<UrlRouteRule> getUrlRouteRules() {
        return Lists.newArrayList(this.urlRouteRules);
    }

    public UrlRouteRuleSetKey getKey() {
        return this.key;
    }

    public FilterLocation getFilterLocation() {
        return this.filterLocation;
    }

    public RoutePredicate<UrlRouteRuleSet> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("key", (Object)this.key).add("filterLocation", (Object)this.filterLocation).add("topLevelPaths", this.topLevelPaths).add("urlRouteRules", this.urlRouteRules).add("predicate", this.predicate).toString();
    }

    public static class Builder {
        private List<UrlRouteRule> urlRouteRules = Lists.newArrayList();
        private List<String> topLevelPaths = Lists.newArrayList();
        private UrlRouteRuleSetKey key;
        private FilterLocation filterLocation = FilterLocation.BEFORE_DISPATCH;
        private RoutePredicate<UrlRouteRuleSet> predicate = RoutePredicates.alwaysTrue();

        public Builder setKey(UrlRouteRuleSetKey key) {
            this.key = (UrlRouteRuleSetKey)Preconditions.checkNotNull((Object)key);
            return this;
        }

        public Builder setLocation(FilterLocation location) {
            this.filterLocation = (FilterLocation)Preconditions.checkNotNull((Object)location);
            return this;
        }

        public Builder setPredicate(RoutePredicate<UrlRouteRuleSet> predicate) {
            this.predicate = (RoutePredicate)Preconditions.checkNotNull(predicate);
            return this;
        }

        public Builder addTopLevelPath(String path) {
            Preconditions.checkNotNull((Object)path);
            this.topLevelPaths.add(path.startsWith("/") ? path : "/" + path);
            return this;
        }

        public Builder addRule(UriTemplate from, UriTemplate to) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, Collections.emptyList(), UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(UriTemplate from, UriTemplate to, List<String> httpVerbs, RoutePredicate<UrlRouteRule> routePredicate, UrlRouteRule.ParameterMode parameterMode) {
            this.urlRouteRules.add(new UrlRouteRule(from, to, httpVerbs, parameterMode, routePredicate));
            return this;
        }

        public Builder addRule(UriTemplate from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs) {
            this.urlRouteRules.add(new UrlRouteRule(from, toUriGenerator, httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(UriTemplate from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, RoutePredicate<UrlRouteRule> routePredicate, UrlRouteRule.ParameterMode parameterMode) {
            this.urlRouteRules.add(new UrlRouteRule(from, toUriGenerator, httpVerbs, parameterMode, routePredicate));
            return this;
        }

        public Builder addRule(String from, String to) {
            this.urlRouteRules.add(new UrlRouteRule(new UriTemplate(from), new UriTemplate(to), Collections.emptyList(), UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(String from, String to, List<String> httpVerbs) {
            this.urlRouteRules.add(new UrlRouteRule(new UriTemplate(from), new UriTemplate(to), httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED));
            return this;
        }

        public Builder addRule(String from, String to, List<String> httpVerbs, RoutePredicate routePredicate) {
            this.urlRouteRules.add(new UrlRouteRule(new UriTemplate(from), new UriTemplate(to), httpVerbs, UrlRouteRule.ParameterMode.PASS_UNMAPPED, (RoutePredicate<UrlRouteRule>)routePredicate));
            return this;
        }

        public UrlRouteRuleSet build() {
            Preconditions.checkNotNull((Object)this.key, (Object)"You must provide a key to identify your rule set");
            Preconditions.checkState((!this.topLevelPaths.isEmpty() ? 1 : 0) != 0, (Object)"You must provide at least one top level path");
            return new UrlRouteRuleSet(this.key, this.topLevelPaths, this.urlRouteRules, this.filterLocation, this.predicate);
        }
    }
}

