/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.prettyurls.api.route;

import com.atlassian.prettyurls.api.route.DestinationUrlGenerator;
import com.atlassian.prettyurls.api.route.RoutePredicate;
import com.atlassian.prettyurls.api.route.RoutePredicates;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.uri.UriTemplate;
import java.util.List;
import java.util.Objects;

public class UrlRouteRule {
    private final UriTemplate from;
    private final UriTemplate to;
    private final DestinationUrlGenerator toUriGenerator;
    private final ParameterMode parameterMode;
    private final List<String> httpVerbs;
    private final RoutePredicate<UrlRouteRule> predicate;

    public UrlRouteRule(UriTemplate from, UriTemplate to, List<String> httpVerbs, ParameterMode parameterMode) {
        this(from, to, httpVerbs, parameterMode, RoutePredicates.alwaysTrue());
    }

    public UrlRouteRule(UriTemplate from, UriTemplate to, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this(from, to, UrlRouteRule.getDefaultToUriGenerator(to), httpVerbs, parameterMode, predicate);
    }

    public UrlRouteRule(UriTemplate from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode) {
        this(from, toUriGenerator, httpVerbs, parameterMode, RoutePredicates.alwaysTrue());
    }

    public UrlRouteRule(UriTemplate from, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this(from, null, toUriGenerator, httpVerbs, parameterMode, predicate);
    }

    private UrlRouteRule(UriTemplate from, UriTemplate to, DestinationUrlGenerator toUriGenerator, List<String> httpVerbs, ParameterMode parameterMode, RoutePredicate<UrlRouteRule> predicate) {
        this.from = (UriTemplate)Preconditions.checkNotNull((Object)from);
        this.to = to;
        this.toUriGenerator = (DestinationUrlGenerator)Preconditions.checkNotNull((Object)toUriGenerator);
        this.httpVerbs = (List)Preconditions.checkNotNull(httpVerbs);
        this.parameterMode = (ParameterMode)((Object)Preconditions.checkNotNull((Object)((Object)parameterMode)));
        this.predicate = (RoutePredicate)Preconditions.checkNotNull(predicate);
    }

    private static DestinationUrlGenerator getDefaultToUriGenerator(UriTemplate to) {
        Preconditions.checkNotNull((Object)to);
        return (request, variables) -> to.createURI(variables);
    }

    public UriTemplate getFrom() {
        return this.from;
    }

    public UriTemplate getTo() {
        return this.to;
    }

    public DestinationUrlGenerator getToUriGenerator() {
        return this.toUriGenerator;
    }

    public ParameterMode getParameterMode() {
        return this.parameterMode;
    }

    public List<String> getHttpVerbs() {
        return this.httpVerbs;
    }

    public RoutePredicate<UrlRouteRule> getPredicate() {
        return this.predicate;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("from", (Object)this.from).add("to", (Object)this.to).add("httpVerbs", this.httpVerbs).add("parameterMode", (Object)this.parameterMode).add("predicate", this.predicate).toString();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UrlRouteRule that = (UrlRouteRule)o;
        return Objects.equals(this.from, that.from) && Objects.equals(this.to, that.to) && this.parameterMode == that.parameterMode && Objects.equals(this.httpVerbs, that.httpVerbs);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.from, this.to, this.parameterMode, this.httpVerbs});
    }

    public static enum ParameterMode {
        PASS_ALL,
        PASS_UNMAPPED,
        PASS_NONE;

    }
}

