/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.internal.featureflags.soy.function;

import com.atlassian.fugue.Option;
import com.atlassian.jira.config.FeatureManager;
import com.atlassian.pocketknife.api.featureflags.FeatureFlag;
import com.atlassian.pocketknife.api.featureflags.FeatureFlagManager;
import com.atlassian.soy.renderer.JsExpression;
import com.atlassian.soy.renderer.SoyClientFunction;
import com.atlassian.soy.renderer.SoyServerFunction;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableSet;
import java.util.Set;

public class FeatureFlagFunction
implements SoyServerFunction<Boolean>,
SoyClientFunction {
    private FeatureFlagManager featureFlagManager;
    private FeatureManager jiraFeatureManager;

    public FeatureFlagFunction(FeatureFlagManager featureFlagManager, FeatureManager jiraFeatureManager) {
        this.featureFlagManager = featureFlagManager;
        this.jiraFeatureManager = jiraFeatureManager;
    }

    public JsExpression generate(JsExpression ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Wrong number of arguments (1 expected)");
        return new JsExpression("require(\"featureflags/feature-manager\").isFeatureEnabled(" + args[0].getText() + ")");
    }

    public String getName() {
        return "isFeatureEnabled";
    }

    public Boolean apply(Object ... args) {
        Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Wrong number of arguments (1 expected)");
        Preconditions.checkArgument((boolean)(args[0] instanceof String), (Object)"The first argument, the feature flag, should be a string");
        String featureKey = (String)args[0];
        return this.isFeatureEnabled(featureKey);
    }

    @VisibleForTesting
    private boolean isFeatureEnabled(String featureKey) {
        Option flagOpt = this.featureFlagManager.getFeatureFlag(featureKey);
        if (flagOpt.isDefined()) {
            return this.featureFlagManager.isEnabled((FeatureFlag)flagOpt.get());
        }
        return this.jiraFeatureManager.isEnabled(featureKey);
    }

    public Set<Integer> validArgSizes() {
        return ImmutableSet.of((Object)1);
    }
}

