/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.pocketknife.api.featureflags;

import com.atlassian.annotations.ExperimentalApi;
import org.apache.commons.lang.Validate;

@ExperimentalApi
public class FeatureFlag {
    public static final String POSTFIX_ENABLED = ".enabled";
    public static final String POSTFIX_DISABLED = ".disabled";
    private String featureKey;
    private boolean defaultOn;

    private FeatureFlag(String featureKey, boolean defaultOn) {
        this.featureKey = featureKey;
        this.defaultOn = defaultOn;
    }

    public String getFeatureKey() {
        return this.featureKey;
    }

    public boolean isOnByDefault() {
        return this.defaultOn;
    }

    public String enabledFeatureKey() {
        return this.featureKey + POSTFIX_ENABLED;
    }

    public String disabledFeatureKey() {
        return this.featureKey + POSTFIX_DISABLED;
    }

    public static FeatureFlag featureFlag(String featureKey) {
        Validate.notNull((Object)featureKey, (String)"Feature key must not be null");
        return new FeatureFlag(featureKey, false);
    }

    public FeatureFlag onByDefault() {
        return new FeatureFlag(this.featureKey, true);
    }

    public FeatureFlag offByDefault() {
        return new FeatureFlag(this.featureKey, false);
    }

    public FeatureFlag defaultedTo(boolean defaultValue) {
        return new FeatureFlag(this.featureKey, defaultValue);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        FeatureFlag that = (FeatureFlag)o;
        return this.defaultOn == that.defaultOn && this.featureKey.equals(that.featureKey);
    }

    public int hashCode() {
        int result = this.featureKey.hashCode();
        result = 31 * result + (this.defaultOn ? 1 : 0);
        return result;
    }

    public String toString() {
        return this.featureKey + ":" + this.defaultOn;
    }
}

