/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.test;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Random;
import org.apache.commons.io.FileUtils;
import org.junit.Assert;

public class PluginTestUtils {
    public static final String PROJECT_VERSION = System.getProperty("project.version");
    public static final String SIMPLE_TEST_JAR = "atlassian-plugins-simpletest-" + PROJECT_VERSION + ".jar";
    public static final String INNER1_TEST_JAR = "atlassian-plugins-innerjarone-" + PROJECT_VERSION + ".jar";
    public static final String INNER2_TEST_JAR = "atlassian-plugins-innerjartwo-" + PROJECT_VERSION + ".jar";
    public static final String FILTER_TEST_JAR = "atlassian-plugins-filtertest-" + PROJECT_VERSION + ".jar";
    private static Random random = new Random();

    public static File getFileForResource(String resourceName) throws URISyntaxException {
        return new File(new URI(PluginTestUtils.class.getClassLoader().getResource(resourceName).toString()));
    }

    public static File createTempDirectory(Class<?> source) throws IOException {
        return PluginTestUtils.createTempDirectory(source.getName());
    }

    public static File createTempDirectory(String name) throws IOException {
        File tmpBase = new File("target", "tmp");
        File tmpDir = new File(tmpBase, name);
        if (tmpDir.exists()) {
            try {
                FileUtils.cleanDirectory((File)tmpDir);
            }
            catch (IOException ioe) {
                String unique = Long.toString(random.nextLong() >>> 1, 26);
                File movedAsideName = new File(tmpBase, name + "-" + unique);
                if (tmpDir.renameTo(movedAsideName)) {
                    tmpDir.mkdirs();
                }
                throw new IOException("Unable to clean up temporary directory: " + tmpDir, ioe);
            }
        } else {
            tmpDir.mkdirs();
        }
        Assert.assertTrue((boolean)tmpDir.exists());
        Assert.assertTrue((boolean)tmpDir.isDirectory());
        Assert.assertEquals((long)0L, (long)tmpDir.list().length);
        return tmpDir.getAbsoluteFile();
    }
}

