/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugin.test;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.IOUtils;
import org.codehaus.commons.compiler.CompileException;
import org.codehaus.janino.ByteArrayClassLoader;
import org.codehaus.janino.SimpleCompiler;

public class PluginJarBuilder {
    private final Map<String, byte[]> jarContents = new HashMap<String, byte[]>();
    private final String name;
    private ClassLoader classLoader;

    public PluginJarBuilder() {
        this("test");
    }

    public PluginJarBuilder(String name) {
        this(name, PluginJarBuilder.class.getClassLoader());
    }

    public PluginJarBuilder(String name, ClassLoader classLoader) {
        this.name = name;
        this.classLoader = classLoader;
    }

    public PluginJarBuilder manifest(Map<String, String> manifest) {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, String> entry : manifest.entrySet()) {
            sb.append(entry.getKey()).append(": ").append(entry.getValue()).append('\n');
        }
        sb.append('\n');
        return this.addResource("META-INF/MANIFEST.MF", sb.toString());
    }

    public PluginJarBuilder addClass(Class<?> aClass) throws IOException {
        this.jarContents.put(aClass.getName().replace('.', '/') + ".class", IOUtils.toByteArray((InputStream)aClass.getResourceAsStream(aClass.getSimpleName() + ".class")));
        return this;
    }

    public PluginJarBuilder addFormattedJava(String className, String ... lines) throws Exception {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line.replace('\'', '\"')).append('\n');
        }
        return this.addJava(className, sb.toString());
    }

    public PluginJarBuilder addJava(String className, String code) throws Exception {
        SimpleCompiler compiler = new SimpleCompiler();
        compiler.setParentClassLoader(this.classLoader);
        try {
            compiler.cook((Reader)new StringReader(code));
        }
        catch (CompileException ex) {
            throw new IllegalArgumentException("Unable to compile " + className, ex);
        }
        this.classLoader = compiler.getClassLoader();
        this.jarContents.put(className.replace('.', '/') + ".class", this.getClassFile(className));
        return this;
    }

    public byte[] getClassFile(String className) throws NoSuchFieldException, IllegalAccessException {
        ByteArrayClassLoader cl = (ByteArrayClassLoader)this.classLoader;
        Field field = cl.getClass().getDeclaredField("classes");
        field.setAccessible(true);
        Map classes = (Map)field.get(cl);
        return (byte[])classes.get(className);
    }

    public PluginJarBuilder addResource(String path, String contents) {
        this.jarContents.put(path, contents.getBytes());
        return this;
    }

    public PluginJarBuilder addFormattedResource(String path, String ... lines) {
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            sb.append(line.replace('\'', '\"')).append('\n');
        }
        this.jarContents.put(path, sb.toString().getBytes());
        return this;
    }

    public PluginJarBuilder addPluginInformation(String key, String name, String version) {
        return this.addPluginInformation(key, name, version, 2);
    }

    public PluginJarBuilder addPluginInformation(String key, String name, String version, int pluginsVersion) {
        return this.addPluginInformation(key, name, version, pluginsVersion, null);
    }

    public PluginJarBuilder addPluginInformation(String key, String name, String version, int pluginsVersion, Map<String, String> params) {
        StringBuilder sb = new StringBuilder();
        sb.append("<atlassian-plugin name=\"").append(name).append("\" key=\"").append(key).append("\" pluginsVersion=\"").append(pluginsVersion).append("\">\n");
        sb.append("    <plugin-info>\n");
        sb.append("        <description>This plugin descriptor is used for testing plugins!</description>\n");
        sb.append("        <version>").append(version).append("</version>\n");
        sb.append("        <vendor name=\"Atlassian Software Systems Pty Ltd\" url=\"http://www.atlassian.com\" />\n");
        if (params != null) {
            for (Map.Entry<String, String> param : params.entrySet()) {
                sb.append("<param name=\"").append(param.getKey()).append("\">").append(param.getValue()).append("</param>\n");
            }
        }
        sb.append("    </plugin-info>");
        sb.append("</atlassian-plugin>");
        this.jarContents.put("atlassian-plugin.xml", sb.toString().getBytes());
        return this;
    }

    public PluginJarBuilder addFile(String path, File file) throws IOException {
        FileInputStream in = new FileInputStream(file);
        this.jarContents.put(path, IOUtils.toByteArray((InputStream)in));
        IOUtils.closeQuietly((InputStream)in);
        return this;
    }

    public File build() throws IOException {
        return this.build(this.createBaseDir());
    }

    private File createBaseDir() {
        File baseDir = new File("target");
        if (!baseDir.exists()) {
            baseDir = new File(System.getProperty("java.io.tmpdir"));
        } else if (!(baseDir = new File(baseDir, "tmp")).exists()) {
            baseDir.mkdir();
        }
        return baseDir;
    }

    public File buildWithNoManifest() throws IOException {
        return this.build(this.createBaseDir(), false);
    }

    public File build(File baseDir) throws IOException {
        return this.build(baseDir, true);
    }

    private File build(File baseDir, boolean createManifest) throws IOException {
        if (createManifest && !this.jarContents.containsKey("META-INF/MANIFEST.MF")) {
            this.jarContents.put("META-INF/MANIFEST.MF", "Manifest-Version: 1.0".getBytes());
        }
        File jarFile = File.createTempFile(this.name, ".jar", baseDir);
        try (ZipOutputStream zout = new ZipOutputStream(new FileOutputStream(jarFile));){
            for (Map.Entry<String, byte[]> entry : this.jarContents.entrySet()) {
                zout.putNextEntry(new ZipEntry(entry.getKey()));
                zout.write(entry.getValue());
            }
        }
        return jarFile;
    }

    public ClassLoader getClassLoader() {
        return this.classLoader;
    }
}

