/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.shortcuts.api;

import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.util.Assertions;

public class KeyboardShortcutOperation {
    private final OperationType type;
    private final String param;

    public KeyboardShortcutOperation(String type, String param) {
        try {
            this.type = OperationType.valueOf(type);
        }
        catch (IllegalArgumentException e) {
            throw new PluginParseException("Invalid operation type '" + type + "' provided");
        }
        this.param = (String)Assertions.notNull((String)"param", (Object)param);
    }

    public OperationType getType() {
        return this.type;
    }

    public String getParam() {
        return this.param;
    }

    public boolean equals(Object other) {
        KeyboardShortcutOperation otherShortcut;
        return other instanceof KeyboardShortcutOperation && (otherShortcut = (KeyboardShortcutOperation)other).getType() == this.getType() && otherShortcut.getParam().equals(this.getParam());
    }

    public int hashCode() {
        return 43 * (37 + this.getParam().hashCode()) + this.getType().hashCode();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum OperationType {
        click,
        goTo,
        followLink,
        moveToAndFocus,
        moveToAndClick,
        moveToNextItem,
        moveToPrevItem,
        execute,
        evaluate;

    }
}

