/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.shortcuts.api;

import com.atlassian.plugin.util.Assertions;
import com.atlassian.plugins.shortcuts.api.KeyboardShortcutOperation;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class KeyboardShortcut
implements Comparable<KeyboardShortcut> {
    private final Set<List<String>> shortcuts;
    private final String context;
    private final KeyboardShortcutOperation operation;
    private final String descriptionI18nKey;
    private final String defaultDescription;
    private final int order;
    private final boolean hidden;

    public KeyboardShortcut(String context, KeyboardShortcutOperation operation, int order, Set<List<String>> shortcuts, String descriptionI18nKey, String defaultDescription, boolean hidden) {
        this.hidden = hidden;
        this.context = (String)Assertions.notNull((String)"context", (Object)context);
        this.shortcuts = new LinkedHashSet<List<String>>(shortcuts);
        this.operation = (KeyboardShortcutOperation)Assertions.notNull((String)"operation", (Object)operation);
        this.order = order;
        this.descriptionI18nKey = descriptionI18nKey;
        this.defaultDescription = defaultDescription;
    }

    public String getContext() {
        return this.context;
    }

    public Set<List<String>> getShortcuts() {
        return this.shortcuts;
    }

    public int getOrder() {
        return this.order;
    }

    public KeyboardShortcutOperation getOperation() {
        return this.operation;
    }

    public String getParameter() {
        return this.operation.getParam();
    }

    public String getDescriptionI18nKey() {
        return this.descriptionI18nKey;
    }

    public String getDefaultDescription() {
        return this.defaultDescription;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    @Override
    public int compareTo(KeyboardShortcut shortcut) {
        int order2 = shortcut.getOrder();
        if (this.order == order2) {
            return 0;
        }
        if (this.order < order2) {
            return -1;
        }
        return 1;
    }

    public String toString() {
        return "KeyboardShortcut{context=" + this.context + ", shortcuts=" + this.shortcuts + ", operation=" + this.operation + ", parameter='" + this.operation.getParam() + '\'' + ", descriptionI18nKey='" + this.descriptionI18nKey + '\'' + ", description='" + this.defaultDescription + '\'' + ", order=" + this.order + ", hidden=" + this.hidden + '}';
    }
}

