/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.search.opensearch;

import com.atlassian.plugins.search.SearchResultsMarshaller;
import com.atlassian.plugins.search.SearchResultsMarshallerFactory;
import com.atlassian.plugins.util.Check;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.search.SearchProvider;
import com.atlassian.sal.api.search.SearchResults;
import com.atlassian.sal.api.user.UserManager;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.text.MessageFormat;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringUtils;

public class OpenSearchServlet
extends HttpServlet {
    private SearchProvider searchProvider;
    private UserManager userManager;
    private ApplicationProperties applicationProperties;
    private SearchResultsMarshallerFactory searchResultsMarshallerFactory;
    public static final String QUERY_PARAM = "query";
    public static final String START_PARAM = "start";
    public static final String COUNT_PARAM = "count";
    public static final String FEED_TYPE_PARAM = "format";
    public static final String IMPERSONATE_PARAM = "impersonate";
    public static final String DEFAULT_COUNT = "10";
    public static final String DEFAULT_FEED_TYPE = "rss_2.0";
    public static final String SEARCH_URL_ENCODING = "UTF-8";

    public OpenSearchServlet(SearchProvider searchProvider, UserManager userManager, ApplicationProperties applicationProperties, SearchResultsMarshallerFactory searchResultsMarshallerFactory) {
        this.searchProvider = Check.notNull(searchProvider, "searchProvider");
        this.userManager = Check.notNull(userManager, "userManager");
        this.applicationProperties = Check.notNull(applicationProperties, "applicationProperties");
        this.searchResultsMarshallerFactory = Check.notNull(searchResultsMarshallerFactory, "searchResultsMarshallerFactory");
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String query = this.extractParam(req, QUERY_PARAM, null, true);
        String queryUrl = this.buildSearchUrl(query, req);
        SearchResults results = this.searchProvider.search(this.getSearchUser(req, resp), queryUrl);
        String feedType = this.extractParam(req, FEED_TYPE_PARAM, DEFAULT_FEED_TYPE, true);
        SearchResultsMarshaller marshaller = this.searchResultsMarshallerFactory.create(feedType);
        resp.setContentType(this.getContentType(feedType));
        marshaller.marshalTo(results, this.applicationProperties.getBaseUrl(), query, resp.getWriter());
    }

    protected String getSearchUser(HttpServletRequest req, HttpServletResponse resp) throws IllegalArgumentException, SecurityException {
        String impersonate = this.extractParam(req, IMPERSONATE_PARAM, null, false);
        if (impersonate == null) {
            return this.userManager.getRemoteUsername();
        }
        if (this.userManager.isSystemAdmin(this.userManager.getRemoteUsername())) {
            if (this.userManager.resolve(impersonate) == null) {
                throw new IllegalArgumentException("User " + impersonate + " does not exist");
            }
            return impersonate;
        }
        resp.setStatus(403);
        throw new SecurityException("User " + this.userManager.getRemoteUsername() + " cannot impersonate " + impersonate);
    }

    protected String buildSearchUrl(String query, HttpServletRequest req) {
        String count = this.extractParam(req, COUNT_PARAM, DEFAULT_COUNT, true);
        String start = this.extractParam(req, START_PARAM, "0", true);
        try {
            return MessageFormat.format("{0}&startIndex={1}&count={2}", URLEncoder.encode(query, SEARCH_URL_ENCODING), URLEncoder.encode(start, SEARCH_URL_ENCODING), URLEncoder.encode(count, SEARCH_URL_ENCODING));
        }
        catch (UnsupportedEncodingException uee) {
            throw new RuntimeException("Failed to encode query URL", uee);
        }
    }

    protected String extractParam(HttpServletRequest req, String key, String defaultValue, boolean required) {
        String supplied = req.getParameter(key);
        if (!StringUtils.isBlank((String)supplied)) {
            return supplied;
        }
        if (defaultValue != null) {
            return defaultValue;
        }
        if (required) {
            throw new IllegalArgumentException("Parameter " + key + " must be supplied");
        }
        return null;
    }

    private String getContentType(String feedType) {
        if (feedType.startsWith("atom")) {
            return "application/atom+xml";
        }
        if (feedType.startsWith("rss")) {
            return "application/rss+xml";
        }
        return "text/xml";
    }
}

