package com.atlassian.plugins.search.feed;

import com.atlassian.plugins.search.SearchResultsMarshaller;
import com.atlassian.sal.api.search.SearchResults;
import com.atlassian.sal.api.search.SearchMatch;
import com.sun.syndication.io.SyndFeedOutput;
import com.sun.syndication.io.FeedException;
import com.sun.syndication.feed.synd.*;
import com.google.common.base.Function;
import com.google.common.collect.Lists;

import java.io.Writer;
import java.io.IOException;
import java.text.MessageFormat;

/**
 * Results marshaller which uses Rome to create results as RSS/Atom feeds
 * https://rome.dev.java.net/
 */
public class RomeFeedMarshaller implements SearchResultsMarshaller
{
    private String type;

    private static final String TITLE_PATTERN = "Search results for query: {0}";
    private static final String DESCRIPTION_PATTERN = "Search results for query: {0}. Search returned {1} results in {2}ms";


    public RomeFeedMarshaller(String type)
    {
        this.type = type;
    }

    public void marshalTo(SearchResults searchResults, String baseUrl, String query, Writer writer) throws IOException
    {
        SyndFeed feed = new SyndFeedImpl();
        feed.setFeedType(type);
        feed.setLink(baseUrl);
        feed.setTitle(MessageFormat.format(TITLE_PATTERN, query));
        feed.setDescription(MessageFormat.format(DESCRIPTION_PATTERN, query, searchResults.getTotalResults(), searchResults.getSearchTime()));

        feed.setEntries(Lists.transform(searchResults.getMatches(), new ResultToFeedItemTransformer()));

        try
        {
            new SyndFeedOutput().output(feed, writer);
        }
        catch (FeedException fe)
        {
            throw new IOException("Failed to create feed", fe);
        }
    }

    private class ResultToFeedItemTransformer implements Function<SearchMatch, SyndEntry>
    {
        public SyndEntry apply(SearchMatch match)
        {
            SyndEntryImpl entry = new SyndEntryImpl();
            entry.setTitle(match.getTitle());
            entry.setLink(match.getUrl());

            SyndContent content = new SyndContentImpl();
            content.setType("text/plain");
            content.setValue(match.getExcerpt());

            entry.setDescription(content);

            return entry;
        }
    }

}
