/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.util;

public class XMLUtil {
    public static String replaceInvalidXmlCharacters(String text) {
        if (text == null) {
            return null;
        }
        char[] chars = text.toCharArray();
        int len = text.length();
        for (int i = 0; i < len; ++i) {
            int ch = text.charAt(i);
            if (ch >= 55296 && ch <= 56319) {
                if (++i < len) {
                    char low = text.charAt(i);
                    if (low < '\udc00' || low > '\udfff') {
                        chars[i - 1] = 65533;
                        chars[i] = 65533;
                        continue;
                    }
                    ch = 65536 + (ch - 55296) * 1024 + (low - 56320);
                } else {
                    chars[i - 1] = 65533;
                    continue;
                }
            }
            if (XMLUtil.isXMLCharacter(ch)) continue;
            chars[i] = 65533;
        }
        return String.valueOf(chars);
    }

    private static boolean isXMLCharacter(int c) {
        if (c == 10 || c == 13 || c == 9) {
            return true;
        }
        if (c < 32) {
            return false;
        }
        if (c <= 55295) {
            return true;
        }
        if (c < 57344) {
            return false;
        }
        if (c <= 65533) {
            return true;
        }
        if (c < 65536) {
            return false;
        }
        return c <= 0x10FFFF;
    }
}

