/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.util;

import java.util.HashMap;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TokenExtractor {
    private static final String TOKEN_DELIM = "$$";
    private static final String KEY_VALUE_DELIM = "=";
    private String str;
    private Map<String, String> tokens = new HashMap<String, String>();
    private String remaining;

    public TokenExtractor(String str) {
        this.str = str;
        this.parse();
    }

    private void parse() {
        int tokenStart;
        int position = 0;
        StringBuilder remaining = new StringBuilder();
        while ((tokenStart = this.str.indexOf(TOKEN_DELIM, position)) != -1) {
            int keyValDelim = this.str.indexOf(KEY_VALUE_DELIM, tokenStart);
            int tokenEnd = this.str.indexOf(TOKEN_DELIM, tokenStart + TOKEN_DELIM.length());
            if (keyValDelim != -1 && tokenEnd != -1 && tokenEnd > keyValDelim) {
                this.tokens.put(this.str.substring(tokenStart + TOKEN_DELIM.length(), keyValDelim), this.str.substring(keyValDelim + KEY_VALUE_DELIM.length(), tokenEnd));
                remaining.append(this.str.substring(position, tokenStart));
                position = tokenEnd + TOKEN_DELIM.length();
                continue;
            }
            remaining.append(this.str.substring(position, tokenStart + TOKEN_DELIM.length()));
            position = tokenStart + TOKEN_DELIM.length();
        }
        remaining.append(this.str.substring(position, this.str.length()));
        this.remaining = remaining.toString();
    }

    public Map<String, String> getTokens() {
        return this.tokens;
    }

    public String getRemaining() {
        return this.remaining;
    }
}

