/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.exception.entity;

import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Request;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.Variant;
import jakarta.xml.bind.annotation.XmlElement;
import jakarta.xml.bind.annotation.XmlRootElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.List;

@XmlRootElement(name="status")
public class UncaughtExceptionEntity {
    private static final Integer INTERNAL_SERVER_ERROR_CODE = Response.Status.INTERNAL_SERVER_ERROR.getStatusCode();
    @XmlElement(name="status-code")
    private final Integer code;
    @XmlElement
    private final String message;
    @XmlElement(name="stack-trace")
    private final String stackTrace;
    private static final MediaType TEXT_PLAIN_UTF8_TYPE = MediaType.valueOf((String)"text/plain; charset=utf-8");
    private static final List<Variant> POSSIBLE_VARIANTS = Variant.mediaTypes((MediaType[])new MediaType[]{MediaType.APPLICATION_XML_TYPE, MediaType.APPLICATION_JSON_TYPE, MediaType.TEXT_PLAIN_TYPE}).add().build();

    public UncaughtExceptionEntity() {
        this.code = null;
        this.message = null;
        this.stackTrace = null;
    }

    public UncaughtExceptionEntity(Throwable throwable, String errorId) {
        this.code = INTERNAL_SERVER_ERROR_CODE;
        this.message = throwable.getMessage();
        boolean shouldSeeStacktrace = System.getProperty("atlassian.rest.response.stacktraces", "0").equals("1");
        if (shouldSeeStacktrace) {
            StringWriter stringWriter = new StringWriter();
            PrintWriter printWriter = new PrintWriter(stringWriter);
            throwable.printStackTrace(printWriter);
            this.stackTrace = stringWriter.toString();
        } else {
            this.stackTrace = "Please contact your admin passing attached Log's referral number: " + errorId;
        }
    }

    public UncaughtExceptionEntity(Integer code, Throwable throwable) {
        this.code = code;
        this.message = throwable.getMessage();
        this.stackTrace = null;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getStackTrace() {
        return this.stackTrace;
    }

    public static MediaType variantFor(Request request) {
        MediaType mediaType;
        Variant variant = request.selectVariant(POSSIBLE_VARIANTS);
        if (variant == null) {
            variant = POSSIBLE_VARIANTS.get(0);
        }
        if ((mediaType = variant.getMediaType()).equals((Object)MediaType.TEXT_PLAIN_TYPE)) {
            return TEXT_PLAIN_UTF8_TYPE;
        }
        return mediaType;
    }

    public String toString() {
        return "code=" + this.code + ", message='" + this.message + "', stackTrace='" + this.stackTrace;
    }
}

