/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.websudo;

import com.atlassian.plugins.rest.api.security.exception.WebSudoRequiredException;
import com.atlassian.plugins.rest.v2.security.websudo.SalWebSudoResourceContext;
import com.atlassian.sal.api.websudo.WebSudoNotRequired;
import com.atlassian.sal.api.websudo.WebSudoRequired;
import java.lang.reflect.Method;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ResourceInfo;
import javax.ws.rs.core.Context;
import javax.ws.rs.ext.Provider;

@Priority(value=1000)
@Provider
public class WebSudoResourceFilter
implements ContainerRequestFilter {
    private final SalWebSudoResourceContext salWebSudoResourceContext;
    @Context
    private ResourceInfo resourceInfo;

    public WebSudoResourceFilter(SalWebSudoResourceContext salWebSudoResourceContext) {
        this.salWebSudoResourceContext = salWebSudoResourceContext;
    }

    public void filter(ContainerRequestContext requestContext) {
        if (this.requiresWebSudo() && this.salWebSudoResourceContext.shouldEnforceWebSudoProtection()) {
            throw new WebSudoRequiredException("This resource requires WebSudo.");
        }
    }

    private boolean requiresWebSudo() {
        Method resourceMethod = this.resourceInfo.getResourceMethod();
        if (null != resourceMethod && resourceMethod.getAnnotation(WebSudoRequired.class) != null) {
            return true;
        }
        if (null != resourceMethod && resourceMethod.getAnnotation(WebSudoNotRequired.class) != null) {
            return false;
        }
        Class resourceClass = this.resourceInfo.getResourceClass();
        if (resourceClass.isAnnotationPresent(WebSudoRequired.class)) {
            return true;
        }
        if (resourceClass.isAnnotationPresent(WebSudoNotRequired.class)) {
            return false;
        }
        Package resourcePackage = this.resourceInfo.getResourceClass().getPackage();
        if (resourcePackage.getAnnotation(WebSudoRequired.class) != null) {
            return true;
        }
        if (resourcePackage.getAnnotation(WebSudoNotRequired.class) != null) {
            return false;
        }
        return false;
    }
}

