/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.cors;

import com.atlassian.plugins.rest.api.internal.security.cors.CorsDefaults;
import com.atlassian.plugins.rest.api.internal.security.cors.CorsHeaders;
import com.atlassian.plugins.rest.v2.security.cors.CorsDefaultService;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.ContainerResponseContext;
import javax.ws.rs.container.ContainerResponseFilter;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Priority(value=3000)
@Provider
public class CorsResourceFilter
implements ContainerRequestFilter,
ContainerResponseFilter {
    public static final String CORS_PREFLIGHT_FAILED = "Cors-Preflight-Failed";
    public static final String CORS_PREFLIGHT_SUCCEEDED = "Cors-Preflight-Succeeded";
    private static final Logger log = LoggerFactory.getLogger(CorsResourceFilter.class);
    private final String allowMethod;
    private final CorsDefaultService corsDefaultService;

    public CorsResourceFilter(String allowMethod, CorsDefaultService corsDefaultService) {
        this.allowMethod = allowMethod;
        this.corsDefaultService = corsDefaultService;
    }

    public void filter(ContainerRequestContext requestContext) throws IOException {
        if (!requestContext.getPropertyNames().contains("Cors-Preflight-Requested")) {
            return;
        }
        try {
            String origin = this.validateSingleOriginInWhitelist(this.corsDefaultService.getCorsDefaults(), requestContext);
            List<CorsDefaults> defaultsWithAllowedOrigin = CorsResourceFilter.allowsOrigin(this.corsDefaultService.getCorsDefaults(), origin);
            Response.ResponseBuilder response = Response.ok();
            this.validateAccessControlRequestMethod(this.allowMethod, requestContext);
            Set<String> allowedRequestHeaders = CorsResourceFilter.getAllowedRequestHeaders(defaultsWithAllowedOrigin, origin);
            this.validateAccessControlRequestHeaders(allowedRequestHeaders, requestContext);
            this.addAccessControlAllowOrigin(response, origin);
            this.conditionallyAddAccessControlAllowCredentials(response, origin, defaultsWithAllowedOrigin);
            this.addAccessControlMaxAge(response);
            this.addAccessControlAllowMethods(response, this.allowMethod);
            this.addAccessControlAllowHeaders(response, allowedRequestHeaders);
            requestContext.setProperty(CORS_PREFLIGHT_SUCCEEDED, (Object)"true");
            requestContext.abortWith(response.build());
        }
        catch (PreflightFailedException ex) {
            Response.ResponseBuilder response = Response.ok();
            requestContext.setProperty(CORS_PREFLIGHT_FAILED, (Object)"true");
            log.info("CORS preflight failed: {}", (Object)ex.getMessage());
            requestContext.abortWith(response.build());
        }
    }

    public void filter(ContainerRequestContext requestContext, ContainerResponseContext responseContext) throws IOException {
        if (requestContext.getProperty(CORS_PREFLIGHT_FAILED) != null || requestContext.getProperty(CORS_PREFLIGHT_SUCCEEDED) != null || CorsResourceFilter.extractOrigin(requestContext) == null) {
            return;
        }
        try {
            String origin = this.validateSingleOriginInWhitelist(this.corsDefaultService.getCorsDefaults(), requestContext);
            List<CorsDefaults> defaultsWithAllowedOrigin = CorsResourceFilter.allowsOrigin(this.corsDefaultService.getCorsDefaults(), origin);
            this.addAccessControlAllowOrigin(responseContext, origin);
            this.conditionallyAddAccessControlAllowCredentials(responseContext, origin, defaultsWithAllowedOrigin);
            this.addAccessControlExposeHeaders(responseContext, CorsResourceFilter.getAllowedResponseHeaders(defaultsWithAllowedOrigin, origin));
        }
        catch (PreflightFailedException ex) {
            log.info("Unable to add CORS headers to response: {}", (Object)ex.getMessage());
        }
    }

    private void addAccessControlExposeHeaders(ContainerResponseContext response, Set<String> allowedHeaders) {
        response.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_EXPOSE_HEADERS.value(), Collections.singletonList(String.join((CharSequence)", ", allowedHeaders)));
    }

    private void addAccessControlAllowHeaders(Response.ResponseBuilder response, Set<String> allowedHeaders) {
        response.header(CorsHeaders.ACCESS_CONTROL_ALLOW_HEADERS.value(), (Object)String.join((CharSequence)", ", allowedHeaders));
    }

    private void addAccessControlAllowMethods(Response.ResponseBuilder response, String allowMethod) {
        response.header(CorsHeaders.ACCESS_CONTROL_ALLOW_METHODS.value(), (Object)allowMethod);
    }

    private void addAccessControlMaxAge(Response.ResponseBuilder response) {
        response.header(CorsHeaders.ACCESS_CONTROL_MAX_AGE.value(), (Object)3600);
    }

    private void addAccessControlAllowOrigin(Response.ResponseBuilder response, String origin) {
        response.header(CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value(), (Object)origin);
    }

    private void addAccessControlAllowOrigin(ContainerResponseContext responseContext, String origin) {
        responseContext.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_ORIGIN.value(), Collections.singletonList(origin));
    }

    private void conditionallyAddAccessControlAllowCredentials(Response.ResponseBuilder response, String origin, Iterable<CorsDefaults> defaultsWithAllowedOrigin) {
        if (CorsResourceFilter.anyAllowsCredentials(defaultsWithAllowedOrigin, origin)) {
            response.header(CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.value(), (Object)"true");
        }
    }

    private void conditionallyAddAccessControlAllowCredentials(ContainerResponseContext responseContext, String origin, Iterable<CorsDefaults> defaultsWithAllowedOrigin) {
        if (CorsResourceFilter.anyAllowsCredentials(defaultsWithAllowedOrigin, origin)) {
            responseContext.getHeaders().put((Object)CorsHeaders.ACCESS_CONTROL_ALLOW_CREDENTIALS.value(), Collections.singletonList("true"));
        }
    }

    private void validateAccessControlRequestHeaders(Set<String> allowedHeaders, ContainerRequestContext requestContext) throws PreflightFailedException {
        List<String> requestedHeaders = (List<String>)requestContext.getHeaders().get((Object)CorsHeaders.ACCESS_CONTROL_REQUEST_HEADERS.value());
        requestedHeaders = requestedHeaders != null ? requestedHeaders : Collections.emptyList();
        HashSet<String> flatRequestedHeaders = new HashSet<String>();
        for (String requestedHeader : requestedHeaders) {
            flatRequestedHeaders.addAll(Arrays.asList(requestedHeader.toLowerCase(Locale.US).trim().split("\\s*,\\s*")));
        }
        Set allowedHeadersLowerCase = allowedHeaders.stream().map(from -> from.toLowerCase(Locale.US)).collect(Collectors.toSet());
        HashSet difference = new HashSet(flatRequestedHeaders);
        difference.removeAll(allowedHeadersLowerCase);
        if (!difference.isEmpty()) {
            throw new PreflightFailedException("Unexpected headers in CORS request: " + new ArrayList(difference));
        }
    }

    private void validateAccessControlRequestMethod(String allowMethod, ContainerRequestContext requestContext) throws PreflightFailedException {
        String requestedMethod = requestContext.getHeaderString(CorsHeaders.ACCESS_CONTROL_REQUEST_METHOD.value());
        if (!allowMethod.equals(requestedMethod)) {
            throw new PreflightFailedException("Invalid method: " + requestedMethod);
        }
    }

    private String validateSingleOriginInWhitelist(Iterable<CorsDefaults> defaults, ContainerRequestContext requestContext) throws PreflightFailedException {
        String origin = CorsResourceFilter.extractOrigin(requestContext);
        this.validateOriginAsUri(origin);
        List<CorsDefaults> allowsOriginResult = CorsResourceFilter.allowsOrigin(defaults, origin);
        if (allowsOriginResult.isEmpty()) {
            throw new PreflightFailedException("Origin '" + origin + "' not in whitelist");
        }
        return origin;
    }

    private void validateOriginAsUri(String origin) throws PreflightFailedException {
        try {
            URI originUri = URI.create(origin);
            if (originUri.isOpaque() || !originUri.isAbsolute()) {
                throw new IllegalArgumentException("The origin URI must be absolute and not opaque.");
            }
        }
        catch (IllegalArgumentException ex) {
            throw new PreflightFailedException("Origin '" + origin + "' is not a valid URI");
        }
    }

    public static String extractOrigin(ContainerRequestContext requestContext) {
        return requestContext.getHeaderString(CorsHeaders.ORIGIN.value());
    }

    private static List<CorsDefaults> allowsOrigin(Iterable<CorsDefaults> delegates, String uri) {
        return StreamSupport.stream(delegates.spliterator(), false).filter((? super T delegate) -> delegate.allowsOrigin(uri)).collect(Collectors.toList());
    }

    private static boolean anyAllowsCredentials(Iterable<CorsDefaults> delegatesWhichAllowOrigin, String uri) {
        for (CorsDefaults defs : delegatesWhichAllowOrigin) {
            if (!defs.allowsCredentials(uri)) continue;
            return true;
        }
        return false;
    }

    private static Set<String> getAllowedRequestHeaders(List<CorsDefaults> delegatesWhichAllowOrigin, String uri) {
        HashSet<String> result = new HashSet<String>();
        for (CorsDefaults defs : delegatesWhichAllowOrigin) {
            result.addAll(defs.getAllowedRequestHeaders(uri));
        }
        return result;
    }

    private static Set<String> getAllowedResponseHeaders(List<CorsDefaults> delegatesWithAllowedOrigin, String uri) {
        HashSet<String> result = new HashSet<String>();
        for (CorsDefaults defs : delegatesWithAllowedOrigin) {
            result.addAll(defs.getAllowedResponseHeaders(uri));
        }
        return result;
    }

    private static class PreflightFailedException
    extends Exception {
        private PreflightFailedException(String message) {
            super(message);
        }
    }
}

