/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.security.cors;

import com.atlassian.plugins.rest.api.internal.security.cors.CorsHeaders;
import com.atlassian.plugins.rest.v2.security.cors.CorsResourceFilter;
import java.io.IOException;
import javax.annotation.Priority;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.container.ContainerRequestFilter;
import javax.ws.rs.container.PreMatching;
import javax.ws.rs.ext.Provider;

@Priority(value=3000)
@PreMatching
@Provider
public class CorsAcceptOptionsPreflightFilter
implements ContainerRequestFilter {
    public void filter(ContainerRequestContext request) throws IOException {
        if (request.getMethod().equals("OPTIONS")) {
            String origin = CorsResourceFilter.extractOrigin(request);
            String targetMethod = request.getHeaderString(CorsHeaders.ACCESS_CONTROL_REQUEST_METHOD.value());
            if (targetMethod != null && origin != null) {
                request.setMethod(targetMethod);
                request.setProperty("Cors-Preflight-Requested", (Object)"true");
            }
        }
    }
}

