/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.expand.resolver;

import com.atlassian.plugins.rest.api.expand.EntityCrawler;
import com.atlassian.plugins.rest.api.expand.ExpandContext;
import com.atlassian.plugins.rest.api.expand.expander.EntityExpander;
import com.atlassian.plugins.rest.api.expand.resolver.EntityExpanderResolver;
import com.atlassian.plugins.rest.v2.expand.DefaultExpandContext;
import java.util.LinkedList;
import java.util.List;

public class ListEntityExpanderResolver
implements EntityExpanderResolver {
    private static final ListExpander EXPANDER = new ListExpander();

    public boolean hasExpander(Class<?> type) {
        return List.class.isAssignableFrom(type);
    }

    public <T> EntityExpander<T> getExpander(Class<? extends T> type) {
        return List.class.isAssignableFrom(type) ? EXPANDER : null;
    }

    private static class ListExpander
    implements EntityExpander<List> {
        private ListExpander() {
        }

        public List expand(ExpandContext<List> context, EntityExpanderResolver expanderResolver, EntityCrawler entityCrawler) {
            LinkedList list = new LinkedList();
            for (Object item : (List)context.getEntity()) {
                DefaultExpandContext itemContext = new DefaultExpandContext(item, context.getExpandable(), context.getEntityExpandParameter());
                EntityExpander entityExpander = item != null ? expanderResolver.getExpander(item.getClass()) : null;
                list.add(entityExpander != null ? entityExpander.expand(itemContext, expanderResolver, entityCrawler) : item);
            }
            return list;
        }
    }
}

