/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.v2.descriptor;

import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.module.Element;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.servlet.ServletModuleManager;
import com.atlassian.plugin.servlet.descriptors.ServletFilterModuleDescriptor;
import com.atlassian.plugins.rest.v2.RestApiContext;
import com.atlassian.plugins.rest.v2.jersey.ResourceConfigFactory;
import com.atlassian.plugins.rest.v2.servlet.RestDelegatingServletFilter;
import com.atlassian.plugins.rest.v2.version.ApiVersion;
import java.util.Objects;
import javax.servlet.Filter;

public class RestServletFilterModuleDescriptor
extends ServletFilterModuleDescriptor {
    private final RestDelegatingServletFilter restDelegatingServletFilter;
    private final RestApiContext restApiContext;
    private static final String DISABLE_WADL_PROPERTY = "com.sun.jersey.config.feature.DisableWADL";

    RestServletFilterModuleDescriptor(OsgiPlugin plugin, ModuleFactory moduleFactory, ServletModuleManager servletModuleManager, RestApiContext restApiContext, ResourceConfigFactory resourceConfigFactory) {
        super(Objects.requireNonNull(moduleFactory, "moduleFactory can't be null"), Objects.requireNonNull(servletModuleManager, "servletModuleManager can't be nul"));
        this.restApiContext = Objects.requireNonNull(restApiContext, "restApiContext can't be null");
        this.restDelegatingServletFilter = new RestDelegatingServletFilter(plugin, restApiContext, resourceConfigFactory);
    }

    public void init(Plugin plugin, Element element) {
        super.init(plugin, element);
        this.getInitParams().put(DISABLE_WADL_PROPERTY, System.getProperty(DISABLE_WADL_PROPERTY, "false"));
        this.restDelegatingServletFilter.registerSingletonsFromInitParams(this.getInitParams());
    }

    protected void validate(Element element) {
    }

    public String getName() {
        return "Rest V2 Servlet Filter";
    }

    public Filter getModule() {
        return this.restDelegatingServletFilter;
    }

    public String getBasePath() {
        return this.restApiContext.getApiPath();
    }

    public ApiVersion getVersion() {
        return this.restApiContext.getVersion();
    }

    private static boolean resourcesAvailable(Plugin plugin, String ... resources) {
        for (String resource : resources) {
            if (plugin.getResource(resource) != null) continue;
            return false;
        }
        return true;
    }
}

