package com.atlassian.plugins.rest.v2.exception;

import javax.annotation.Priority;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.Priorities;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import com.atlassian.plugins.rest.api.model.Status;

/**
 * A generic exception mapper that will map {@link NotFoundException not found exceptions}.
 *
 * @since 1.0
 */
@Priority(Priorities.USER)
@Provider
public class NotFoundExceptionMapper implements ExceptionMapper<NotFoundException> {
    private static final Logger log = LoggerFactory.getLogger(NotFoundExceptionMapper.class);

    @Context
    Request request;

    public Response toResponse(NotFoundException exception) {
        log.debug(
                "Not Found Exception in REST: {}: {}",
                exception.getResponse().getStatus(),
                exception.getResponse(),
                exception);

        return Status.notFound()
                .message(exception.getMessage())
                .responseBuilder()
                .type(Status.variantFor(request))
                .build();
    }
}
