/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module;

import com.atlassian.plugin.ModuleDescriptor;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.descriptors.AbstractModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;
import com.atlassian.plugin.osgi.factory.OsgiPlugin;
import com.atlassian.plugin.servlet.filter.FilterLocation;
import com.atlassian.plugins.rest.module.ApiVersion;
import com.atlassian.plugins.rest.module.InvalidVersionException;
import com.atlassian.plugins.rest.module.RestApiContext;
import com.atlassian.plugins.rest.module.RestServletFilterModuleDescriptor;
import com.atlassian.plugins.rest.module.servlet.RestServletModuleManager;
import com.google.common.base.Preconditions;
import java.util.HashSet;
import java.util.Set;
import org.dom4j.Element;
import org.osgi.framework.ServiceRegistration;

public class RestModuleDescriptor
extends AbstractModuleDescriptor<Object> {
    private final RestServletModuleManager servletModuleManager;
    private final String restContext;
    private RestApiContext restApiContext;
    private ServiceRegistration serviceRegistration;
    private RestServletFilterModuleDescriptor restServletFilterModuleDescriptor;
    private OsgiPlugin osgiPlugin;
    private Element element;

    public RestModuleDescriptor(ModuleFactory moduleFactory, RestServletModuleManager servletModuleManager, String restContext) {
        super(moduleFactory);
        this.servletModuleManager = (RestServletModuleManager)Preconditions.checkNotNull((Object)servletModuleManager);
        this.restContext = (String)Preconditions.checkNotNull((Object)restContext);
    }

    public void init(Plugin plugin, Element element) throws PluginParseException {
        super.init(plugin, element);
        this.restApiContext = new RestApiContext(this.restContext, this.parsePath(element), this.parseVersion(element), this.parsePackages(element));
        this.osgiPlugin = (OsgiPlugin)plugin;
        this.element = element;
    }

    private String parsePath(Element element) {
        return element.attributeValue("path");
    }

    private Set<String> parsePackages(Element rootElement) {
        HashSet<String> packages = new HashSet<String>();
        for (Element pkgElement : rootElement.elements("package")) {
            packages.add(pkgElement.getTextTrim());
        }
        return packages;
    }

    private ApiVersion parseVersion(Element element) {
        try {
            return new ApiVersion(element.attributeValue("version"));
        }
        catch (InvalidVersionException e) {
            throw new InvalidVersionException(this.plugin, this, e);
        }
    }

    private Element updateElementForFilterConfiguration(Element element) {
        Element copy = element.createCopy();
        copy.addAttribute("location", FilterLocation.BEFORE_DISPATCH.name());
        copy.addElement("url-pattern").addText(this.restApiContext.getContextlessPathToVersion() + "/*");
        copy.addAttribute("key", copy.attributeValue("key") + "-filter");
        return copy;
    }

    public Object getModule() {
        return null;
    }

    public boolean equals(Object o) {
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        if (((Object)((Object)this)).getClass() != o.getClass()) {
            return false;
        }
        RestModuleDescriptor that = (RestModuleDescriptor)((Object)o);
        return that.getCompleteKey().equals(this.getCompleteKey());
    }

    public int hashCode() {
        return this.getCompleteKey().hashCode();
    }

    public void disabled() {
        if (this.restServletFilterModuleDescriptor != null) {
            this.restServletFilterModuleDescriptor.disabled();
            this.restServletFilterModuleDescriptor = null;
        }
        if (this.serviceRegistration != null) {
            try {
                this.serviceRegistration.unregister();
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
            this.serviceRegistration = null;
        }
        super.disabled();
    }

    public void enabled() {
        super.enabled();
        this.restServletFilterModuleDescriptor = new RestServletFilterModuleDescriptor(this.osgiPlugin, this.moduleFactory, this.servletModuleManager, this.restApiContext);
        this.restServletFilterModuleDescriptor.init(this.plugin, this.updateElementForFilterConfiguration(this.element));
        this.restServletFilterModuleDescriptor.enabled();
        this.serviceRegistration = this.osgiPlugin.getBundle().getBundleContext().registerService(new String[]{((Object)((Object)this.restServletFilterModuleDescriptor)).getClass().getName(), ModuleDescriptor.class.getName()}, (Object)this.restServletFilterModuleDescriptor, null);
    }
}

