/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.security;

import com.atlassian.plugins.rest.common.security.AuthenticationContext;
import com.atlassian.plugins.rest.module.servlet.ServletUtils;
import com.atlassian.sal.api.user.UserManager;
import com.google.common.base.Preconditions;
import java.security.Principal;

public class SalAuthenticationContext
implements AuthenticationContext {
    private final UserManager userManager;

    public SalAuthenticationContext(UserManager userManager) {
        this.userManager = (UserManager)Preconditions.checkNotNull((Object)userManager);
    }

    public Principal getPrincipal() {
        String userName = this.getUserName();
        return userName != null ? new SalPrincipal(userName) : null;
    }

    public boolean isAuthenticated() {
        return this.getUserName() != null;
    }

    private String getUserName() {
        return this.userManager.getRemoteUsername(ServletUtils.getHttpServletRequest());
    }

    private static class SalPrincipal
    implements Principal {
        private final String userName;

        SalPrincipal(String userName) {
            this.userName = (String)Preconditions.checkNotNull((Object)userName);
        }

        public String getName() {
            return this.userName;
        }

        public int hashCode() {
            return this.userName.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof SalPrincipal && ((SalPrincipal)obj).userName.equals(this.userName);
        }

        public String toString() {
            return this.userName;
        }
    }
}

