/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.scanner;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLDecoder;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.FieldVisitor;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.osgi.framework.Bundle;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class AnnotatedClassScanner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AnnotatedClassScanner.class);
    private static final String REFERENCE_PROTOCOL = "reference:";
    private static final String FILE_PROTOCOL = "file:";
    private final Bundle bundle;
    private final Set<String> annotations;

    public AnnotatedClassScanner(Bundle bundle, Class<?> ... annotations) {
        Validate.notNull((Object)bundle);
        Validate.notEmpty((Object[])annotations, (String)"You gotta scan for something!");
        this.bundle = bundle;
        this.annotations = this.getAnnotationSet(annotations);
    }

    public Set<Class<?>> scan(String ... basePackages) {
        File bundleFile = this.getBundleFile(this.bundle);
        if (!bundleFile.isFile() || !bundleFile.exists()) {
            throw new RuntimeException("Could not identify Bundle at location <" + this.bundle.getLocation() + ">");
        }
        return this.indexJar(bundleFile, this.preparePackages(basePackages));
    }

    File getBundleFile(Bundle bundle) {
        File bundleFile;
        String bundleLocation = bundle.getLocation();
        if (bundleLocation.startsWith(REFERENCE_PROTOCOL)) {
            bundleLocation = bundleLocation.substring(REFERENCE_PROTOCOL.length());
        }
        if (bundleLocation.startsWith(FILE_PROTOCOL)) {
            try {
                bundleFile = new File(URLDecoder.decode(new URL(bundleLocation).getFile(), "UTF-8"));
            }
            catch (MalformedURLException e) {
                throw new RuntimeException("Could not parse Bundle location as URL <" + bundleLocation + ">", e);
            }
            catch (UnsupportedEncodingException e) {
                throw new IllegalStateException("Obviously something is wrong with your JVM... It doesn't support UTF-8 !?!", e);
            }
        } else {
            bundleFile = new File(bundleLocation);
        }
        return bundleFile;
    }

    private Set<String> preparePackages(String ... packages) {
        HashSet<String> packageNames = new HashSet<String>();
        for (String packageName : packages) {
            String newPackageName = StringUtils.replaceChars((String)packageName, (char)'.', (char)'/');
            if (!newPackageName.endsWith("/")) {
                packageNames.add(newPackageName + '/');
                continue;
            }
            packageNames.add(newPackageName);
        }
        return packageNames;
    }

    private Set<String> getAnnotationSet(Class ... annotations) {
        HashSet<String> formatedAnnotations = new HashSet<String>();
        for (Class cls : annotations) {
            formatedAnnotations.add("L" + cls.getName().replaceAll("\\.", "/") + ";");
        }
        return formatedAnnotations;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<Class<?>> indexJar(File file, Set<String> packageNames) {
        HashSet classes = new HashSet<Class<?>>(){

            @Override
            public boolean add(Class<?> c) {
                return c != null && super.add(c);
            }
        };
        JarFile jar = null;
        try {
            jar = new JarFile(file);
            Enumeration<JarEntry> entries = jar.entries();
            block11: while (entries.hasMoreElements()) {
                JarEntry jarEntry = entries.nextElement();
                if (jarEntry.isDirectory() || !jarEntry.getName().endsWith(".class")) continue;
                if (packageNames.isEmpty()) {
                    classes.add(this.analyzeClassFile(jar, jarEntry));
                    continue;
                }
                for (String packageName : packageNames) {
                    if (!jarEntry.getName().startsWith(packageName)) continue;
                    classes.add(this.analyzeClassFile(jar, jarEntry));
                    continue block11;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("Exception while processing file, " + file, (Throwable)e);
        }
        finally {
            try {
                if (jar != null) {
                    jar.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error closing jar file, {}", (Object)jar.getName());
            }
        }
        return classes;
    }

    private Class analyzeClassFile(JarFile jarFile, JarEntry entry) {
        AnnotatedClassVisitor visitor = new AnnotatedClassVisitor(this.annotations);
        this.getClassReader(jarFile, entry).accept(visitor, 0);
        return visitor.hasAnnotation() ? this.getClassForName(visitor.className) : null;
    }

    private ClassReader getClassReader(JarFile jarFile, JarEntry entry) {
        InputStream is = null;
        try {
            is = jarFile.getInputStream(entry);
            ClassReader classReader = new ClassReader(is);
            return classReader;
        }
        catch (IOException ex) {
            throw new RuntimeException("Error accessing input stream of the jar file, " + jarFile.getName() + ", entry, " + entry.getName(), ex);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (IOException ex) {
                LOGGER.error("Error closing input stream of the jar file, {}, entry, {}, closed.", (Object)jarFile.getName(), (Object)entry.getName());
            }
        }
    }

    private Class getClassForName(String className) {
        try {
            return this.bundle.loadClass(className.replaceAll("/", "."));
        }
        catch (ClassNotFoundException ex) {
            throw new RuntimeException("A class file of the class name, " + className + " is identified but the class could not be loaded", ex);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class AnnotatedClassVisitor
    implements ClassVisitor {
        private final Set<String> annotations;
        private String className;
        private boolean isScoped;
        private boolean isAnnotated;

        public AnnotatedClassVisitor(Set<String> annotations) {
            this.annotations = annotations;
        }

        @Override
        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
            this.className = name;
            this.isScoped = (access & 1) != 0;
            this.isAnnotated = false;
        }

        @Override
        public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
            this.isAnnotated |= this.annotations.contains(desc);
            return null;
        }

        @Override
        public void visitInnerClass(String name, String outerName, String innerName, int access) {
            if (this.className.equals(name)) {
                this.isScoped = (access & 1) != 0;
                this.isScoped &= (access & 8) == 8;
            }
        }

        boolean hasAnnotation() {
            return this.isScoped && this.isAnnotated;
        }

        @Override
        public void visitEnd() {
        }

        @Override
        public void visitOuterClass(String string, String string0, String string1) {
        }

        @Override
        public FieldVisitor visitField(int i, String string, String string0, String string1, Object object) {
            return null;
        }

        @Override
        public void visitSource(String string, String string0) {
        }

        @Override
        public void visitAttribute(Attribute attribute) {
        }

        @Override
        public MethodVisitor visitMethod(int i, String string, String string0, String string1, String[] string2) {
            if (this.isAnnotated) {
                return null;
            }
            return new MethodVisitor(){

                public AnnotationVisitor visitAnnotationDefault() {
                    return null;
                }

                public AnnotationVisitor visitAnnotation(String desc, boolean visible) {
                    AnnotatedClassVisitor.this.isAnnotated = (byte)(AnnotatedClassVisitor.this.isAnnotated | (AnnotatedClassVisitor.this.annotations.contains(desc) ? 1 : 0));
                    return null;
                }

                public AnnotationVisitor visitParameterAnnotation(int parameter, String desc, boolean visible) {
                    return null;
                }

                public void visitAttribute(Attribute attr) {
                }

                public void visitCode() {
                }

                public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
                }

                public void visitInsn(int opcode) {
                }

                public void visitIntInsn(int opcode, int operand) {
                }

                public void visitVarInsn(int opcode, int var) {
                }

                public void visitTypeInsn(int opcode, String type) {
                }

                public void visitFieldInsn(int opcode, String owner, String name, String desc) {
                }

                public void visitMethodInsn(int opcode, String owner, String name, String desc) {
                }

                public void visitJumpInsn(int opcode, Label label) {
                }

                public void visitLabel(Label label) {
                }

                public void visitLdcInsn(Object cst) {
                }

                public void visitIincInsn(int var, int increment) {
                }

                public void visitTableSwitchInsn(int min, int max, Label dflt, Label[] labels) {
                }

                public void visitLookupSwitchInsn(Label dflt, int[] keys, Label[] labels) {
                }

                public void visitMultiANewArrayInsn(String desc, int dims) {
                }

                public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
                }

                public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
                }

                public void visitLineNumber(int line, Label start) {
                }

                public void visitMaxs(int maxStack, int maxLocals) {
                }

                public void visitEnd() {
                }
            };
        }
    }
}

