/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module.jersey;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugin.Plugin;
import com.atlassian.plugins.rest.module.ChainingClassLoader;
import com.atlassian.plugins.rest.module.ContextClassLoaderSwitchingProxy;
import com.atlassian.plugins.rest.module.jersey.JerseyEntityHandler;
import com.atlassian.plugins.rest.module.jersey.JerseyRequest;
import com.atlassian.sal.api.net.NonMarshallingRequestFactory;
import com.atlassian.sal.api.net.Request;
import com.atlassian.sal.api.net.RequestFactory;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import org.osgi.framework.Bundle;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JerseyRequestFactory
implements RequestFactory {
    private final RequestFactory<? extends Request> delegateRequestFactory;
    private final Plugin plugin;
    private final Bundle bundle;
    private volatile JerseyEntityHandler jerseyEntityHandler;

    public JerseyRequestFactory(NonMarshallingRequestFactory<? extends Request> delegateRequestFactory, Plugin plugin, Bundle bundle) {
        this.plugin = plugin;
        this.delegateRequestFactory = delegateRequestFactory;
        this.bundle = bundle;
    }

    public Request createRequest(Request.MethodType methodType, String s) {
        this.ensureInitalised();
        Request delegateRequest = this.delegateRequestFactory.createRequest(methodType, s);
        JerseyRequest request = new JerseyRequest(delegateRequest, this.jerseyEntityHandler, this.plugin);
        return (Request)Proxy.newProxyInstance(this.getClass().getClassLoader(), new Class[]{Request.class}, (InvocationHandler)new ContextClassLoaderSwitchingProxy(request, this.getChainingClassLoader(this.plugin)));
    }

    public boolean supportsHeader() {
        this.ensureInitalised();
        return this.delegateRequestFactory.supportsHeader();
    }

    private void ensureInitalised() {
        if (this.jerseyEntityHandler == null) {
            this.jerseyEntityHandler = this.createHandler();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JerseyEntityHandler createHandler() {
        ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
        ChainingClassLoader chainingClassLoader = this.getChainingClassLoader(this.plugin);
        try {
            Thread.currentThread().setContextClassLoader(chainingClassLoader);
            JerseyEntityHandler jerseyEntityHandler = new JerseyEntityHandler((AutowireCapablePlugin)this.plugin, this.bundle);
            return jerseyEntityHandler;
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldClassLoader);
        }
    }

    void destroy() {
        if (this.jerseyEntityHandler != null) {
            this.jerseyEntityHandler.destroy();
        }
    }

    private ChainingClassLoader getChainingClassLoader(Plugin plugin) {
        return new ChainingClassLoader(this.getClass().getClassLoader(), plugin.getClassLoader());
    }
}

