/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.module;

import com.atlassian.plugins.rest.module.ApiVersion;
import com.google.common.base.Preconditions;
import java.util.Set;
import org.apache.commons.lang.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RestApiContext {
    public static final String SLASH = "/";
    public static final String LATEST = "/latest";
    public static final String ANY_PATH_PATTERN = "/*";
    private final String restContext;
    private final String apiPath;
    private final ApiVersion version;
    private final Set<String> packages;

    public RestApiContext(String restContext, String apiContext, ApiVersion version, Set<String> packages) {
        this.restContext = this.prependSlash((String)Preconditions.checkNotNull((Object)restContext));
        this.apiPath = this.prependSlash((String)Preconditions.checkNotNull((Object)apiContext));
        this.version = (ApiVersion)Preconditions.checkNotNull((Object)version);
        this.packages = (Set)Preconditions.checkNotNull(packages);
    }

    public String getRestContext() {
        return this.restContext;
    }

    public String getApiPath() {
        return this.apiPath;
    }

    public ApiVersion getVersion() {
        return this.version;
    }

    public String getPathToVersion() {
        return this.getPathToVersion(this.version);
    }

    public String getPathToLatest() {
        return this.getPathToVersion(LATEST);
    }

    public String getPathToVersion(String version) {
        return this.restContext + this.getContextlessPathToVersion(version);
    }

    private String getPathToVersion(ApiVersion version) {
        return this.restContext + this.getContextlessPathToVersion(version);
    }

    public String getContextlessPathToVersion() {
        return this.getContextlessPathToVersion(this.version);
    }

    private String getContextlessPathToVersion(String version) {
        return ApiVersion.isNone(version) ? this.apiPath : this.apiPath + this.prependSlash(version);
    }

    private String getContextlessPathToVersion(ApiVersion version) {
        return version.isNone() ? this.apiPath : this.apiPath + this.prependSlash(version.toString());
    }

    private String prependSlash(String path) {
        return StringUtils.startsWith((String)path, (String)SLASH) ? path : SLASH + path;
    }

    public Set<String> getPackages() {
        return this.packages;
    }
}

