/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.plugins.rest.common.security.jersey.XsrfResourceFilter;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.Provider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class XsrfResourceFilterFactory
implements ResourceFilterFactory {
    private HttpContext httpContext;
    private XsrfTokenValidator xsrfTokenValidator;

    public XsrfResourceFilterFactory(HttpContext httpContext, XsrfTokenValidator xsrfTokenValidator) {
        this.httpContext = (HttpContext)Preconditions.checkNotNull((Object)httpContext);
        this.xsrfTokenValidator = (XsrfTokenValidator)Preconditions.checkNotNull((Object)xsrfTokenValidator);
    }

    @Override
    public List<ResourceFilter> create(AbstractMethod method) {
        if (method.isAnnotationPresent(RequiresXsrfCheck.class) || method.getResource().isAnnotationPresent(RequiresXsrfCheck.class)) {
            XsrfResourceFilter xsrfResourceFilter = new XsrfResourceFilter();
            xsrfResourceFilter.setHttpContext(this.httpContext);
            xsrfResourceFilter.setXsrfTokenValidator(this.xsrfTokenValidator);
            return Collections.singletonList(xsrfResourceFilter);
        }
        return Collections.emptyList();
    }
}

