package com.atlassian.plugins.rest.common.security.jersey;

import javax.ws.rs.ext.Provider;

import com.sun.jersey.spi.container.ContainerRequestFilter;
import com.sun.jersey.spi.container.ContainerResponseFilter;
import com.sun.jersey.spi.container.ResourceFilter;

import com.atlassian.plugins.rest.common.security.AuthenticationRequiredException;
import com.atlassian.plugins.rest.common.security.AuthorisationException;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;

import static java.util.Objects.requireNonNull;

/**
 *
 * Filter that can be used to restrict access to resources to system administrators.
 * <p>
 * @deprecated since 6.3.0. Use {@link com.atlassian.plugins.rest.common.security.SystemAdminOnly}
 * @since 1.1
 */
@Deprecated
@Provider
public class SysadminOnlyResourceFilter implements ResourceFilter {
    private final UserManager userManager;

    public SysadminOnlyResourceFilter(UserManager userManager) {
        this.userManager = requireNonNull(userManager);
    }

    public ContainerRequestFilter getRequestFilter() {
        return containerRequest -> {
            UserKey userKey = userManager.getRemoteUserKey();
            if (userKey == null) {
                throw new AuthenticationRequiredException();
            }
            if (!userManager.isSystemAdmin(userKey)) {
                throw new AuthorisationException(
                        "Client must be authenticated as a system administrator to access this resource.");
            }
            return containerRequest;
        };
    }

    public ContainerResponseFilter getResponseFilter() {
        return null;
    }
}
