package com.atlassian.plugins.rest.common.security.jersey;

import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;

import com.atlassian.plugins.rest.common.Status;

/**
 * Exception mapper that takes care of {@link SecurityException security exceptions}
 *
 * @since 1.0
 */
@Provider
public class SecurityExceptionMapper implements ExceptionMapper<SecurityException> {
    @Context
    Request request;

    public Response toResponse(SecurityException exception) {
        return Status.unauthorized()
                .message(exception.getMessage())
                .responseBuilder()
                .type(Status.variantFor(request))
                .build();
    }
}
