package com.atlassian.plugins.rest.common.security.jersey;

import java.util.Collections;
import java.util.List;
import javax.ws.rs.ext.Provider;

import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;

import com.atlassian.sal.api.features.DarkFeatureManager;
import com.atlassian.sal.api.user.UserManager;

import static java.util.Objects.requireNonNull;

/**
 * A {@link ResourceFilterFactory} that checks whether the client is authenticated or not.
 *
 * @see AuthenticatedResourceFilter
 */
@Provider
public class AuthenticatedResourceFilterFactory implements ResourceFilterFactory {
    private final UserManager userManager;
    private final DarkFeatureManager darkFeatureManager;

    public AuthenticatedResourceFilterFactory(
            final UserManager userManager, final DarkFeatureManager darkFeatureManager) {
        this.userManager = requireNonNull(userManager);
        this.darkFeatureManager = requireNonNull(darkFeatureManager);
    }

    public List<ResourceFilter> create(AbstractMethod abstractMethod) {
        return Collections.singletonList(
                new AuthenticatedResourceFilter(abstractMethod, userManager, darkFeatureManager));
    }
}
