package com.atlassian.plugins.rest.common.json;

import java.util.Collections;

import org.codehaus.jackson.jaxrs.JacksonJaxbJsonProvider;
import org.codehaus.jackson.jaxrs.JacksonJsonProvider;
import org.codehaus.jackson.map.AnnotationIntrospector;
import org.codehaus.jackson.map.DeserializationConfig;
import org.codehaus.jackson.map.Module;
import org.codehaus.jackson.map.ObjectMapper;
import org.codehaus.jackson.map.SerializationConfig;
import org.codehaus.jackson.map.annotate.JsonSerialize.Inclusion;
import org.codehaus.jackson.map.introspect.JacksonAnnotationIntrospector;
import org.codehaus.jackson.xc.JaxbAnnotationIntrospector;

public class JacksonJsonProviderFactory {
    public JacksonJsonProvider create() {
        return create(Collections.<Module>emptyList());
    }

    public JacksonJsonProvider create(Iterable<? extends Module> modules) {
        ObjectMapper mapper = new ObjectMapper();

        /* This is what MapperConfigurator would do to a default ObjectMapper */
        AnnotationIntrospector intr =
                AnnotationIntrospector.pair(new JacksonAnnotationIntrospector(), new JaxbAnnotationIntrospector());
        mapper.setDeserializationConfig(mapper.getDeserializationConfig().withAnnotationIntrospector(intr));
        mapper.setSerializationConfig(mapper.getSerializationConfig().withAnnotationIntrospector(intr));

        /* In the absence of a specific annotation for @JsonSerialize(include), ignore null fields when serializing */
        mapper.setSerializationInclusion(Inclusion.NON_NULL);

        for (Module module : modules) {
            mapper.registerModule(module);
        }

        mapper.registerModule(new GuavaIterableCapableModule());

        JacksonJaxbJsonProvider provider =
                new JacksonJaxbJsonProvider(mapper, JacksonJaxbJsonProvider.DEFAULT_ANNOTATIONS);

        // The below configuration is not effective, the visibility is still default values:
        // Visibility: getter: PUBLIC_ONLY, isGetter: PUBLIC_ONLY, setter: ANY, creator: ANY, field: PUBLIC_ONLY
        provider.configure(SerializationConfig.Feature.AUTO_DETECT_GETTERS, false);
        provider.configure(SerializationConfig.Feature.AUTO_DETECT_FIELDS, false);
        provider.configure(DeserializationConfig.Feature.AUTO_DETECT_SETTERS, false);
        provider.configure(DeserializationConfig.Feature.AUTO_DETECT_FIELDS, false);
        return provider;
    }
}
