package com.atlassian.plugins.rest.common.security;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

/**
 * <p>An annotation to tell that resources are accessible by anonymous users (i.e. not authenticated user).</p>
 *
 * <p>The default for all resources is to require authentication, those resources that don't require authentication
 * should use this annotation.</p>
 *
 * @see AnonymousSiteAccess
 * @see UnrestrictedAccess
 * @deprecated since 6.3.0 due to ambiguous name and resulting mis-usage. Use {@link AnonymousSiteAccess} where resource
 * is intended to be accessible to anonymous users, only when site has anonymous user access enabled. Use
 * {@link UnrestrictedAccess} if resource should be accessible to all users irrespective of any other factor.
 */
@Deprecated
@Target({ElementType.TYPE, ElementType.METHOD})
@Retention(RetentionPolicy.RUNTIME)
public @interface AnonymousAllowed {
}
