/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.filter;

import com.atlassian.annotations.tenancy.TenancyScope;
import com.atlassian.annotations.tenancy.TenantAware;
import com.google.common.collect.ImmutableMap;
import com.sun.jersey.spi.container.ContainerRequest;
import com.sun.jersey.spi.container.ContainerRequestFilter;
import java.net.URI;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.ws.rs.core.UriBuilder;
import javax.ws.rs.ext.Provider;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.Validate;

@Provider
public class ExtensionJerseyFilter
implements ContainerRequestFilter {
    private static final String DOT = ".";
    private final Collection<Pattern> pathExcludePatterns;
    @TenantAware(value=TenancyScope.TENANTLESS)
    static final Map<String, String> EXTENSION_TO_ACCEPT_HEADER = new ImmutableMap.Builder().put((Object)"txt", (Object)"text/plain").put((Object)"htm", (Object)"text/html").put((Object)"html", (Object)"text/html").put((Object)"json", (Object)"application/json").put((Object)"xml", (Object)"application/xml").put((Object)"atom", (Object)"application/atom+xml").build();

    public ExtensionJerseyFilter() {
        this.pathExcludePatterns = new LinkedList<Pattern>();
    }

    public ExtensionJerseyFilter(Collection<String> pathExcludePatterns) {
        Validate.notNull(pathExcludePatterns);
        this.pathExcludePatterns = this.compilePatterns(pathExcludePatterns);
    }

    public ContainerRequest filter(ContainerRequest request) {
        String absolutePath = request.getAbsolutePath().toString();
        String extension = StringUtils.substringAfterLast((String)absolutePath, (String)DOT);
        if (this.shouldFilter("/" + StringUtils.difference((String)request.getBaseUri().toString(), (String)absolutePath), extension)) {
            request.getRequestHeaders().putSingle((Object)"Accept", (Object)EXTENSION_TO_ACCEPT_HEADER.get(extension));
            String absolutePathWithoutExtension = StringUtils.substringBeforeLast((String)absolutePath, (String)DOT);
            request.setUris(request.getBaseUri(), this.getRequestUri(absolutePathWithoutExtension, (Map<String, List<String>>)request.getQueryParameters()));
        }
        return request;
    }

    private boolean shouldFilter(String restPath, String extension) {
        for (Pattern pattern : this.pathExcludePatterns) {
            if (!pattern.matcher(restPath).matches()) continue;
            return false;
        }
        return EXTENSION_TO_ACCEPT_HEADER.containsKey(extension);
    }

    private URI getRequestUri(String absolutePathWithoutExtension, Map<String, List<String>> queryParams) {
        UriBuilder requestUriBuilder = UriBuilder.fromPath((String)absolutePathWithoutExtension);
        for (Map.Entry<String, List<String>> queryParamEntry : queryParams.entrySet()) {
            for (String value : queryParamEntry.getValue()) {
                requestUriBuilder.queryParam(queryParamEntry.getKey(), new Object[]{value});
            }
        }
        return requestUriBuilder.build(new Object[0]);
    }

    private Collection<Pattern> compilePatterns(Collection<String> pathExcludePatterns) {
        LinkedList<Pattern> patterns = new LinkedList<Pattern>();
        for (String pattern : pathExcludePatterns) {
            patterns.add(Pattern.compile(pattern));
        }
        return patterns;
    }
}

