/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.error.jersey;

import com.atlassian.plugins.rest.common.error.jersey.UncaughtExceptionEntity;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ThrowableExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(Throwable t) {
        if (t instanceof WebApplicationException) {
            WebApplicationException webEx = (WebApplicationException)t;
            if (webEx.getResponse().getStatus() == Response.Status.INTERNAL_SERVER_ERROR.getStatusCode()) {
                log.error("Server Error in REST: " + webEx.getResponse().getStatus() + ": " + webEx.getResponse(), t);
            } else {
                log.debug("REST response: {}: {}", (Object)webEx.getResponse().getStatus(), (Object)webEx.getResponse());
            }
            return webEx.getResponse();
        }
        log.error("Uncaught exception thrown by REST service: " + t.getMessage(), t);
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new UncaughtExceptionEntity(t)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
    }
}

