/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.annotations.security.XsrfProtectionExcluded;
import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.plugins.rest.common.security.RequiresXsrfCheck;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaults;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaultsModuleDescriptor;
import com.atlassian.plugins.rest.common.security.jersey.OriginBasedXsrfResourceFilter;
import com.atlassian.plugins.rest.common.security.jersey.XsrfResourceFilter;
import com.atlassian.sal.api.web.context.HttpContext;
import com.atlassian.sal.api.xsrf.XsrfTokenValidator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.lang.annotation.Annotation;
import java.lang.reflect.AnnotatedElement;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.POST;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Provider
public class XsrfResourceFilterFactory
implements ResourceFilterFactory {
    private static final String XSRF_ANNOTATION_CLASS_NAME = RequiresXsrfCheck.class.getSimpleName();
    private static final Logger log = LoggerFactory.getLogger(XsrfResourceFilterFactory.class);
    private final HttpContext httpContext;
    private final XsrfTokenValidator xsrfTokenValidator;
    private final PluginModuleTracker<CorsDefaults, CorsDefaultsModuleDescriptor> pluginModuleTracker;

    public XsrfResourceFilterFactory(HttpContext httpContext, XsrfTokenValidator xsrfTokenValidator, PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.httpContext = (HttpContext)Preconditions.checkNotNull((Object)httpContext);
        this.xsrfTokenValidator = (XsrfTokenValidator)Preconditions.checkNotNull((Object)xsrfTokenValidator);
        this.pluginModuleTracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, CorsDefaultsModuleDescriptor.class);
    }

    @VisibleForTesting
    boolean hasRequiresXsrfCheckAnnotation(AnnotatedElement annotatedElement) {
        if (annotatedElement.isAnnotationPresent(RequiresXsrfCheck.class)) {
            return true;
        }
        for (Annotation annotation : annotatedElement.getAnnotations()) {
            if (!annotation.annotationType().getSimpleName().equals(XSRF_ANNOTATION_CLASS_NAME)) continue;
            return true;
        }
        return false;
    }

    private static boolean isXsrfProtectionExcludedAnnotationPresent(Annotation[] annotations) {
        for (Annotation annotation : annotations) {
            if (!annotation.annotationType().getCanonicalName().equals(XsrfProtectionExcluded.class.getCanonicalName())) continue;
            if (!annotation.annotationType().equals(XsrfProtectionExcluded.class)) {
                log.warn("Detected usage of the com.atlassian.annotations.security.XsrfProtectionExcluded annotation loaded from elsewhere. " + XsrfProtectionExcluded.class.getClassLoader() + " != " + annotation.annotationType().getClassLoader());
            }
            return true;
        }
        return false;
    }

    public List<ResourceFilter> create(AbstractMethod method) {
        XsrfResourceFilter xsrfResourceFilter = null;
        if (XsrfResourceFilterFactory.isXsrfProtectionExcludedAnnotationPresent(method.getAnnotations())) {
            return Collections.emptyList();
        }
        if (this.hasRequiresXsrfCheckAnnotation((AnnotatedElement)method) || this.hasRequiresXsrfCheckAnnotation((AnnotatedElement)method.getResource())) {
            xsrfResourceFilter = new XsrfResourceFilter();
        } else if (method.isAnnotationPresent(POST.class)) {
            xsrfResourceFilter = new OriginBasedXsrfResourceFilter();
        }
        if (xsrfResourceFilter == null) {
            return Collections.emptyList();
        }
        xsrfResourceFilter.setHttpContext(this.httpContext);
        xsrfResourceFilter.setXsrfTokenValidator(this.xsrfTokenValidator);
        xsrfResourceFilter.setPluginModuleTracker(this.pluginModuleTracker);
        return Collections.singletonList(xsrfResourceFilter);
    }
}

