/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.expand.entity;

import com.atlassian.plugins.rest.common.expand.entity.ListWrapperCallback;
import com.atlassian.plugins.rest.common.expand.parameter.Indexes;
import com.google.common.collect.Lists;
import java.util.LinkedList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ListWrapperCallBacks {
    public static <T> ListWrapperCallback<T> identity(final List<T> items) {
        return new ListWrapperCallback<T>(){

            @Override
            public List<T> getItems(Indexes indexes) {
                return items;
            }
        };
    }

    public static <T> ListWrapperCallback<T> ofList(List<T> items) {
        return ListWrapperCallBacks.ofList(items, Integer.MAX_VALUE);
    }

    public static <T> ListWrapperCallback<T> ofList(final List<T> items, final int maxResults) {
        return new ListWrapperCallback<T>(){

            @Override
            public List<T> getItems(Indexes indexes) {
                LinkedList toReturn = Lists.newLinkedList();
                for (Integer i : indexes.getIndexes(items.size())) {
                    if (i < items.size()) {
                        toReturn.add(items.get(i));
                    }
                    if (toReturn.size() != maxResults) continue;
                    break;
                }
                return toReturn;
            }
        };
    }
}

