/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.error.jersey;

import com.atlassian.plugins.rest.common.error.jersey.UncaughtExceptionEntity;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Request;
import javax.ws.rs.core.Response;
import javax.ws.rs.ext.ExceptionMapper;
import javax.ws.rs.ext.Provider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class ThrowableExceptionMapper
implements ExceptionMapper<Throwable> {
    private static final Logger log = LoggerFactory.getLogger(ThrowableExceptionMapper.class);
    @Context
    Request request;

    public Response toResponse(Throwable t) {
        log.error("Uncaught exception thrown by REST service", t);
        if (t instanceof WebApplicationException) {
            return ((WebApplicationException)t).getResponse();
        }
        return Response.status((Response.Status)Response.Status.INTERNAL_SERVER_ERROR).entity((Object)new UncaughtExceptionEntity(t)).type(UncaughtExceptionEntity.variantFor(this.request)).build();
    }
}

