/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.security.jersey;

import com.atlassian.plugin.PluginAccessor;
import com.atlassian.plugin.event.PluginEventManager;
import com.atlassian.plugin.tracker.DefaultPluginModuleTracker;
import com.atlassian.plugin.tracker.PluginModuleTracker;
import com.atlassian.plugins.rest.common.security.CorsAllowed;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaults;
import com.atlassian.plugins.rest.common.security.descriptor.CorsDefaultsModuleDescriptor;
import com.atlassian.plugins.rest.common.security.jersey.CorsResourceFilter;
import com.sun.jersey.api.model.AbstractMethod;
import com.sun.jersey.spi.container.ResourceFilter;
import com.sun.jersey.spi.container.ResourceFilterFactory;
import java.lang.annotation.Annotation;
import java.util.Collections;
import java.util.List;
import javax.ws.rs.HttpMethod;
import javax.ws.rs.ext.Provider;
import org.springframework.beans.factory.DisposableBean;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Provider
public class CorsResourceFilterFactory
implements ResourceFilterFactory,
DisposableBean {
    private final PluginModuleTracker<CorsDefaults, CorsDefaultsModuleDescriptor> tracker;

    public CorsResourceFilterFactory(PluginAccessor pluginAccessor, PluginEventManager pluginEventManager) {
        this.tracker = new DefaultPluginModuleTracker(pluginAccessor, pluginEventManager, CorsDefaultsModuleDescriptor.class);
    }

    public List<ResourceFilter> create(AbstractMethod method) {
        if (method.isAnnotationPresent(CorsAllowed.class) || method.getResource().isAnnotationPresent(CorsAllowed.class) || method.getResource().getResourceClass().getPackage().isAnnotationPresent(CorsAllowed.class)) {
            String targetMethod = "GET";
            for (Annotation ann : method.getAnnotations()) {
                HttpMethod m = ann.annotationType().getAnnotation(HttpMethod.class);
                if (m == null) continue;
                targetMethod = m.value();
                break;
            }
            return Collections.singletonList(new CorsResourceFilter(this.tracker, targetMethod));
        }
        return Collections.emptyList();
    }

    public void destroy() throws Exception {
        this.tracker.close();
    }
}

