/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.plugins.rest.common.interceptor.impl;

import com.atlassian.plugin.AutowireCapablePlugin;
import com.atlassian.plugins.rest.common.interceptor.InterceptorChain;
import com.atlassian.plugins.rest.common.interceptor.ResourceInterceptor;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
class InterceptorChainBuilder {
    private final LinkedHashMap<Class<? extends ResourceInterceptor>, ResourceInterceptor> defaultResourceInterceptors = new LinkedHashMap();
    private final AutowireCapablePlugin plugin;

    public InterceptorChainBuilder(AutowireCapablePlugin plugin, ResourceInterceptor ... resourceInterceptors) {
        for (ResourceInterceptor resourceInterceptor : resourceInterceptors) {
            this.defaultResourceInterceptors.put(resourceInterceptor.getClass(), resourceInterceptor);
        }
        this.plugin = plugin;
    }

    public List<ResourceInterceptor> getResourceInterceptorsForMethod(Method m) {
        InterceptorChain chain = m.getAnnotation(InterceptorChain.class);
        if (chain == null && (chain = m.getDeclaringClass().getAnnotation(InterceptorChain.class)) == null) {
            chain = m.getDeclaringClass().getPackage().getAnnotation(InterceptorChain.class);
        }
        if (chain != null) {
            return this.buildFromClass(chain.value());
        }
        return new ArrayList<ResourceInterceptor>(this.defaultResourceInterceptors.values());
    }

    private List<ResourceInterceptor> buildFromClass(Class<? extends ResourceInterceptor>[] resourceInterceptorClasses) {
        ArrayList<ResourceInterceptor> resourceInterceptors = new ArrayList<ResourceInterceptor>();
        for (Class<? extends ResourceInterceptor> resourceInterceptorClass : resourceInterceptorClasses) {
            if (this.defaultResourceInterceptors.containsKey(resourceInterceptorClass)) {
                resourceInterceptors.add(this.defaultResourceInterceptors.get(resourceInterceptorClass));
                continue;
            }
            resourceInterceptors.add((ResourceInterceptor)this.plugin.autowire(resourceInterceptorClass));
        }
        return resourceInterceptors;
    }
}

